/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.elasticsearch;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

final class IndexNameFormatter {
    private static final String DAILY_INDEX_FORMAT = "yyyy-MM-dd";
    private final String index;
    private final ThreadLocal<SimpleDateFormat> dateFormat;

    IndexNameFormatter(String index) {
        this.index = index;
        this.dateFormat = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                SimpleDateFormat result = new SimpleDateFormat(IndexNameFormatter.DAILY_INDEX_FORMAT);
                result.setTimeZone(TimeZone.getTimeZone("UTC"));
                return result;
            }
        };
    }

    String indexNameForTimestamp(long timestampMillis) {
        return this.index + "-" + this.dateFormat.get().format(new Date(timestampMillis));
    }

    String catchAll() {
        return this.index + "-*";
    }
}

