/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.mysql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.Executor;
import javax.sql.DataSource;
import org.jooq.ExecuteListenerProvider;
import org.jooq.Table;
import org.jooq.conf.Settings;
import zipkin.Component;
import zipkin.internal.Lazy;
import zipkin.internal.Nullable;
import zipkin.internal.Util;
import zipkin.storage.AsyncSpanConsumer;
import zipkin.storage.AsyncSpanStore;
import zipkin.storage.SpanStore;
import zipkin.storage.StorageAdapters;
import zipkin.storage.StorageComponent;
import zipkin.storage.mysql.DSLContexts;
import zipkin.storage.mysql.HasIpv6;
import zipkin.storage.mysql.MySQLSpanConsumer;
import zipkin.storage.mysql.MySQLSpanStore;
import zipkin.storage.mysql.internal.generated.DefaultCatalog;
import zipkin.storage.mysql.internal.generated.tables.ZipkinAnnotations;
import zipkin.storage.mysql.internal.generated.tables.ZipkinSpans;

public final class MySQLStorage
implements StorageComponent {
    private final DataSource datasource;
    private final Executor executor;
    private final DSLContexts context;
    final Lazy<Boolean> hasIpv6;
    private final SpanStore spanStore;
    private final AsyncSpanStore asyncSpanStore;
    private final AsyncSpanConsumer asyncSpanConsumer;

    public static Builder builder() {
        return new Builder();
    }

    MySQLStorage(Builder builder) {
        this.datasource = (DataSource)Util.checkNotNull((Object)builder.datasource, (String)"datasource");
        this.executor = (Executor)Util.checkNotNull((Object)builder.executor, (String)"executor");
        this.context = new DSLContexts(builder.settings, builder.listenerProvider);
        this.hasIpv6 = new HasIpv6(this.datasource, this.context);
        this.spanStore = new MySQLSpanStore(this.datasource, this.context, this.hasIpv6);
        this.asyncSpanStore = StorageAdapters.blockingToAsync((SpanStore)this.spanStore, (Executor)this.executor);
        this.asyncSpanConsumer = StorageAdapters.blockingToAsync((StorageAdapters.SpanConsumer)new MySQLSpanConsumer(this.datasource, this.context, this.hasIpv6), (Executor)this.executor);
    }

    public DataSource datasource() {
        return this.datasource;
    }

    public SpanStore spanStore() {
        return this.spanStore;
    }

    public AsyncSpanStore asyncSpanStore() {
        return this.asyncSpanStore;
    }

    public AsyncSpanConsumer asyncSpanConsumer() {
        return this.asyncSpanConsumer;
    }

    public Component.CheckResult check() {
        try (Connection conn = this.datasource.getConnection();){
            if (!this.context.get(conn).meta().getSchemas().contains((Object)DefaultCatalog.DEFAULT_CATALOG.ZIPKIN)) {
                throw new IllegalStateException("Zipkin schema is missing");
            }
        }
        catch (RuntimeException | SQLException e) {
            return Component.CheckResult.failed((Exception)e);
        }
        return Component.CheckResult.OK;
    }

    public void close() {
    }

    void clear() {
        try (Connection conn = this.datasource.getConnection();){
            this.context.get(conn).truncate((Table)ZipkinSpans.ZIPKIN_SPANS).execute();
            this.context.get(conn).truncate((Table)ZipkinAnnotations.ZIPKIN_ANNOTATIONS).execute();
        }
        catch (RuntimeException | SQLException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        System.setProperty("org.jooq.no-logo", "true");
    }

    public static final class Builder {
        private DataSource datasource;
        private Settings settings = new Settings().withRenderSchema(Boolean.valueOf(false));
        private ExecuteListenerProvider listenerProvider;
        private Executor executor;

        public Builder datasource(DataSource datasource) {
            this.datasource = (DataSource)Util.checkNotNull((Object)datasource, (String)"datasource");
            return this;
        }

        public Builder settings(Settings settings) {
            this.settings = (Settings)Util.checkNotNull((Object)settings, (String)"settings");
            return this;
        }

        public Builder listenerProvider(@Nullable ExecuteListenerProvider listenerProvider) {
            this.listenerProvider = listenerProvider;
            return this;
        }

        public Builder executor(Executor executor) {
            this.executor = (Executor)Util.checkNotNull((Object)executor, (String)"executor");
            return this;
        }

        public MySQLStorage build() {
            return new MySQLStorage(this);
        }

        Builder() {
        }
    }
}

