/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.mysql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.sql.DataSource;
import org.jooq.DSLContext;
import org.jooq.InsertFinalStep;
import org.jooq.InsertSetMoreStep;
import org.jooq.Table;
import zipkin.Annotation;
import zipkin.Span;
import zipkin.internal.ApplyTimestampAndDuration;
import zipkin.storage.StorageAdapters;
import zipkin.storage.mysql.DSLContexts;
import zipkin.storage.mysql.Schema;
import zipkin.storage.mysql.internal.generated.tables.ZipkinAnnotations;
import zipkin.storage.mysql.internal.generated.tables.ZipkinSpans;

final class MySQLSpanConsumer
implements StorageAdapters.SpanConsumer {
    private final DataSource datasource;
    private final DSLContexts context;
    private final Schema schema;

    MySQLSpanConsumer(DataSource datasource, DSLContexts context, Schema schema) {
        this.datasource = datasource;
        this.context = context;
        this.schema = schema;
    }

    public void accept(List<Span> spans) {
        if (spans.isEmpty()) {
            return;
        }
        try (Connection conn = this.datasource.getConnection();){
            DSLContext create = this.context.get(conn);
            ArrayList<InsertFinalStep> inserts = new ArrayList<InsertFinalStep>();
            for (Span span : spans) {
                InsertSetMoreStep insert;
                Long overridingTimestamp = ApplyTimestampAndDuration.authoritativeTimestamp((Span)span);
                Long timestamp = overridingTimestamp != null ? overridingTimestamp : ApplyTimestampAndDuration.guessTimestamp((Span)span);
                LinkedHashMap<Object, Object> updateFields = new LinkedHashMap<Object, Object>();
                if (!span.name.equals("") && !span.name.equals("unknown")) {
                    updateFields.put(ZipkinSpans.ZIPKIN_SPANS.NAME, span.name);
                }
                if (overridingTimestamp != null) {
                    updateFields.put(ZipkinSpans.ZIPKIN_SPANS.START_TS, overridingTimestamp);
                }
                if (span.duration != null) {
                    updateFields.put(ZipkinSpans.ZIPKIN_SPANS.DURATION, span.duration);
                }
                InsertSetMoreStep insertSpan = create.insertInto((Table)ZipkinSpans.ZIPKIN_SPANS).set(ZipkinSpans.ZIPKIN_SPANS.TRACE_ID, (Object)span.traceId).set(ZipkinSpans.ZIPKIN_SPANS.ID, (Object)span.id).set(ZipkinSpans.ZIPKIN_SPANS.PARENT_ID, (Object)span.parentId).set(ZipkinSpans.ZIPKIN_SPANS.NAME, (Object)span.name).set(ZipkinSpans.ZIPKIN_SPANS.DEBUG, (Object)span.debug).set(ZipkinSpans.ZIPKIN_SPANS.START_TS, (Object)timestamp).set(ZipkinSpans.ZIPKIN_SPANS.DURATION, (Object)span.duration);
                if (span.traceIdHigh != 0L && this.schema.hasTraceIdHigh) {
                    insertSpan.set(ZipkinSpans.ZIPKIN_SPANS.TRACE_ID_HIGH, (Object)span.traceIdHigh);
                }
                inserts.add((InsertFinalStep)(updateFields.isEmpty() ? insertSpan.onDuplicateKeyIgnore() : insertSpan.onDuplicateKeyUpdate().set(updateFields)));
                for (Annotation annotation : span.annotations) {
                    insert = create.insertInto((Table)ZipkinAnnotations.ZIPKIN_ANNOTATIONS).set(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.TRACE_ID, (Object)span.traceId).set(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.SPAN_ID, (Object)span.id).set(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_KEY, (Object)annotation.value).set(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_TYPE, (Object)-1).set(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_TIMESTAMP, (Object)annotation.timestamp);
                    if (span.traceIdHigh != 0L && this.schema.hasTraceIdHigh) {
                        insert.set(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.TRACE_ID_HIGH, (Object)span.traceIdHigh);
                    }
                    if (annotation.endpoint != null) {
                        insert.set(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_SERVICE_NAME, (Object)annotation.endpoint.serviceName);
                        insert.set(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_IPV4, (Object)annotation.endpoint.ipv4);
                        if (annotation.endpoint.ipv6 != null && this.schema.hasIpv6) {
                            insert.set(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_IPV6, (Object)annotation.endpoint.ipv6);
                        }
                        insert.set(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_PORT, (Object)annotation.endpoint.port);
                    }
                    inserts.add(insert.onDuplicateKeyIgnore());
                }
                for (Annotation annotation : span.binaryAnnotations) {
                    insert = create.insertInto((Table)ZipkinAnnotations.ZIPKIN_ANNOTATIONS).set(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.TRACE_ID, (Object)span.traceId).set(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.SPAN_ID, (Object)span.id).set(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_KEY, (Object)annotation.key).set(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_VALUE, (Object)annotation.value).set(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_TYPE, (Object)annotation.type.value).set(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_TIMESTAMP, (Object)timestamp);
                    if (span.traceIdHigh != 0L && this.schema.hasTraceIdHigh) {
                        insert.set(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.TRACE_ID_HIGH, (Object)span.traceIdHigh);
                    }
                    if (annotation.endpoint != null) {
                        insert.set(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_SERVICE_NAME, (Object)annotation.endpoint.serviceName);
                        insert.set(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_IPV4, (Object)annotation.endpoint.ipv4);
                        if (annotation.endpoint.ipv6 != null && this.schema.hasIpv6) {
                            insert.set(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_IPV6, (Object)annotation.endpoint.ipv6);
                        }
                        insert.set(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_PORT, (Object)annotation.endpoint.port);
                    }
                    inserts.add(insert.onDuplicateKeyIgnore());
                }
            }
            create.batch(inserts).execute();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

