/*
 * Decompiled with CFR 0.152.
 */
package io.zipkin.server.brave;

import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.ServerTracer;
import com.github.kristofa.brave.SpanCollector;
import io.zipkin.Endpoint;
import io.zipkin.SpanStore;
import io.zipkin.server.brave.ApiTracerConfiguration;
import io.zipkin.server.brave.JDBCTracerConfiguration;
import io.zipkin.server.brave.SpanStoreSpanCollector;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
@ConditionalOnClass(value={ServerTracer.class})
@Import(value={ApiTracerConfiguration.class, JDBCTracerConfiguration.class})
@EnableScheduling
public class BraveConfiguration {
    @Autowired
    private SpanStoreSpanCollector spanCollector;

    @Scheduled(fixedDelayString="${zipkin.collector.delayMillisec:1000}")
    public void flushSpans() {
        this.spanCollector.flush();
    }

    @Bean
    @Scope
    Endpoint local(@Value(value="${server.port}") int port) {
        int ipv4;
        try {
            ipv4 = Collections.list(NetworkInterface.getNetworkInterfaces()).stream().flatMap(i -> Collections.list(i.getInetAddresses()).stream()).filter(ip -> ip instanceof Inet4Address && ip.isSiteLocalAddress()).map(InetAddress::getAddress).map(bytes -> new BigInteger((byte[])bytes).intValue()).findAny().get();
        }
        catch (Exception ignored) {
            ipv4 = 2130706433;
        }
        return Endpoint.create((String)"zipkin-query", (int)ipv4, (int)port);
    }

    @Bean
    SpanStoreSpanCollector spanCollector(@Lazy SpanStore spanStore) {
        return new SpanStoreSpanCollector(spanStore);
    }

    @Bean
    @Scope
    Brave brave(@Qualifier(value="local") Endpoint localEndpoint, SpanStoreSpanCollector spanCollector) {
        return new Brave.Builder(localEndpoint.ipv4, (int)localEndpoint.port.shortValue(), localEndpoint.serviceName).traceFilters(Collections.emptyList()).spanCollector((SpanCollector)spanCollector).build();
    }
}

