/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal;

import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.spring.ArmeriaServerConfigurator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import zipkin2.collector.Collector;
import zipkin2.collector.CollectorMetrics;
import zipkin2.collector.CollectorSampler;
import zipkin2.server.internal.ZipkinGrpcCollector;
import zipkin2.storage.StorageComponent;

@ConditionalOnProperty(name={"zipkin.collector.grpc.enabled"})
final class ZipkinGrpcCollector {
    ZipkinGrpcCollector() {
    }

    @Bean
    ArmeriaServerConfigurator grpcCollectorConfigurator(StorageComponent storage, CollectorSampler sampler, CollectorMetrics metrics) {
        CollectorMetrics grpcMetrics = metrics.forTransport("grpc");
        Collector collector = Collector.newBuilder(this.getClass()).storage(storage).sampler(sampler).metrics(grpcMetrics).build();
        return sb -> sb.service("/zipkin.proto3.SpanService/Report", (Service)new SpanService(collector, grpcMetrics));
    }
}

