/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal;

import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.cors.CorsServiceBuilder;
import com.linecorp.armeria.server.file.HttpFileBuilder;
import com.linecorp.armeria.server.metric.PrometheusExpositionService;
import com.linecorp.armeria.spring.ArmeriaServerConfigurator;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.config.MeterFilter;
import io.prometheus.client.CollectorRegistry;
import java.time.Duration;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import zipkin2.server.internal.ZipkinHttpCollector;
import zipkin2.server.internal.ZipkinQueryApiV2;
import zipkin2.server.internal.health.ZipkinHealthController;
import zipkin2.server.internal.prometheus.ZipkinMetricsController;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration(proxyBeanMethods=false)
public class ZipkinHttpConfiguration {
    public static final MediaType MEDIA_TYPE_ACTUATOR = MediaType.parse((String)"application/vnd.spring-boot.actuator.v2+json;charset=UTF-8");

    @Bean
    ArmeriaServerConfigurator serverConfigurator(Optional<ZipkinQueryApiV2> httpQuery, Optional<ZipkinHttpCollector> httpCollector, Optional<ZipkinHealthController> healthController, Optional<ZipkinMetricsController> metricsController, Optional<MeterRegistry> meterRegistry, Optional<CollectorRegistry> collectorRegistry) {
        return sb -> {
            httpQuery.ifPresent(h -> {
                sb.annotatedService(httpQuery.get());
                sb.annotatedService("/zipkin", httpQuery.get());
            });
            httpCollector.ifPresent(arg_0 -> ((ServerBuilder)sb).annotatedService(arg_0));
            healthController.ifPresent(arg_0 -> ((ServerBuilder)sb).annotatedService(arg_0));
            metricsController.ifPresent(arg_0 -> ((ServerBuilder)sb).annotatedService(arg_0));
            collectorRegistry.ifPresent(registry -> {
                PrometheusExpositionService prometheusService = new PrometheusExpositionService(registry);
                sb.service("/actuator/prometheus", (Service)prometheusService);
                sb.service("/prometheus", (Service)prometheusService);
            });
            sb.service("/actuator/info", (Service)ZipkinHttpConfiguration.infoService((MediaType)MEDIA_TYPE_ACTUATOR));
            sb.service("/info", (Service)ZipkinHttpConfiguration.infoService((MediaType)MediaType.JSON_UTF_8));
            sb.requestTimeout(Duration.ofSeconds(11L));
            meterRegistry.ifPresent(m -> m.config().meterFilter(MeterFilter.deny(id -> {
                String uri = id.getTag("uri");
                return uri != null && (uri.startsWith("/actuator") || uri.startsWith("/health") || uri.startsWith("/info") || uri.startsWith("/metrics") || uri.startsWith("/prometheus"));
            })));
        };
    }

    @Order
    @Bean
    ArmeriaServerConfigurator corsConfigurator(@Value(value="${zipkin.query.allowed-origins:*}") String allowedOrigins) {
        CorsServiceBuilder corsBuilder = CorsServiceBuilder.forOrigins((String[])allowedOrigins.split(",")).allowRequestMethods(new HttpMethod[]{HttpMethod.GET, HttpMethod.POST}).allowRequestHeaders(new CharSequence[]{HttpHeaderNames.CONTENT_TYPE, HttpHeaderNames.of((CharSequence)"X-GRPC-WEB")}).exposeHeaders(new CharSequence[]{"grpc-status", "grpc-message", "armeria.grpc.ThrowableProto-bin"});
        return builder -> builder.decorator(arg_0 -> ((CorsServiceBuilder)corsBuilder).build(arg_0));
    }

    static HttpService infoService(MediaType mediaType) {
        return HttpFileBuilder.ofResource((String)"info.json").contentType(mediaType).build().asService();
    }
}

