/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal;

import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.ResponseHeadersBuilder;
import com.linecorp.armeria.server.annotation.Blocking;
import com.linecorp.armeria.server.annotation.Default;
import com.linecorp.armeria.server.annotation.ExceptionHandler;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import zipkin2.Call;
import zipkin2.Span;
import zipkin2.codec.DependencyLinkBytesEncoder;
import zipkin2.codec.SpanBytesEncoder;
import zipkin2.internal.JsonCodec;
import zipkin2.internal.WriteBuffer;
import zipkin2.server.internal.BodyIsExceptionMessage;
import zipkin2.storage.QueryRequest;
import zipkin2.storage.StorageComponent;

/*
 * Exception performing whole class analysis ignored.
 */
@ConditionalOnProperty(name={"zipkin.query.enabled"}, matchIfMissing=true)
@ExceptionHandler(value=BodyIsExceptionMessage.class)
public class ZipkinQueryApiV2 {
    final String storageType;
    final StorageComponent storage;
    final long defaultLookback;
    final int namesMaxAge;
    final List<String> autocompleteKeys;
    volatile int serviceCount;
    static final WriteBuffer.Writer<String> QUOTED_STRING_WRITER = new /* Unavailable Anonymous Inner Class!! */;

    ZipkinQueryApiV2(StorageComponent storage, @Value(value="${zipkin.storage.type:mem}") String storageType, @Value(value="${zipkin.query.lookback:86400000}") long defaultLookback, @Value(value="${zipkin.query.names-max-age:300}") int namesMaxAge, @Value(value="${zipkin.storage.autocomplete-keys:}") List<String> autocompleteKeys) {
        this.storage = storage;
        this.storageType = storageType;
        this.defaultLookback = defaultLookback;
        this.namesMaxAge = namesMaxAge;
        this.autocompleteKeys = autocompleteKeys;
    }

    @Get(value="/api/v2/dependencies")
    @Blocking
    public AggregatedHttpResponse getDependencies(@Param(value="endTs") long endTs, @Param(value="lookback") Optional<Long> lookback) throws IOException {
        Call call = this.storage.spanStore().getDependencies(endTs, lookback.orElse(this.defaultLookback).longValue());
        return ZipkinQueryApiV2.jsonResponse((byte[])DependencyLinkBytesEncoder.JSON_V1.encodeList((List)call.execute()));
    }

    @Get(value="/api/v2/services")
    @Blocking
    public AggregatedHttpResponse getServiceNames() throws IOException {
        List serviceNames = (List)this.storage.serviceAndSpanNames().getServiceNames().execute();
        this.serviceCount = serviceNames.size();
        return this.maybeCacheNames(this.serviceCount > 3, serviceNames);
    }

    @Get(value="/api/v2/spans")
    @Blocking
    public AggregatedHttpResponse getSpanNames(@Param(value="serviceName") String serviceName) throws IOException {
        List spanNames = (List)this.storage.serviceAndSpanNames().getSpanNames(serviceName).execute();
        return this.maybeCacheNames(this.serviceCount > 3, spanNames);
    }

    @Get(value="/api/v2/remoteServices")
    @Blocking
    public AggregatedHttpResponse getRemoteServiceNames(@Param(value="serviceName") String serviceName) throws IOException {
        List remoteServiceNames = (List)this.storage.serviceAndSpanNames().getRemoteServiceNames(serviceName).execute();
        return this.maybeCacheNames(this.serviceCount > 3, remoteServiceNames);
    }

    @Get(value="/api/v2/traces")
    @Blocking
    public AggregatedHttpResponse getTraces(@Param(value="serviceName") Optional<String> serviceName, @Param(value="remoteServiceName") Optional<String> remoteServiceName, @Param(value="spanName") Optional<String> spanName, @Param(value="annotationQuery") Optional<String> annotationQuery, @Param(value="minDuration") Optional<Long> minDuration, @Param(value="maxDuration") Optional<Long> maxDuration, @Param(value="endTs") Optional<Long> endTs, @Param(value="lookback") Optional<Long> lookback, @Default(value="10") @Param(value="limit") int limit) throws IOException {
        QueryRequest queryRequest = QueryRequest.newBuilder().serviceName((String)serviceName.orElse(null)).remoteServiceName((String)remoteServiceName.orElse(null)).spanName((String)spanName.orElse(null)).parseAnnotationQuery((String)annotationQuery.orElse(null)).minDuration((Long)minDuration.orElse(null)).maxDuration((Long)maxDuration.orElse(null)).endTs(endTs.orElse(System.currentTimeMillis()).longValue()).lookback(lookback.orElse(this.defaultLookback).longValue()).limit(limit).build();
        List traces = (List)this.storage.spanStore().getTraces(queryRequest).execute();
        return ZipkinQueryApiV2.jsonResponse((byte[])ZipkinQueryApiV2.writeTraces((SpanBytesEncoder)SpanBytesEncoder.JSON_V2, (List)traces));
    }

    @Get(value="/api/v2/trace/{traceId}")
    @Blocking
    public AggregatedHttpResponse getTrace(@Param(value="traceId") String traceId) throws IOException {
        traceId = Span.normalizeTraceId((String)traceId);
        List trace = (List)this.storage.traces().getTrace(traceId).execute();
        if (trace == null) {
            return AggregatedHttpResponse.of((HttpStatus)HttpStatus.NOT_FOUND, (MediaType)MediaType.ANY_TEXT_TYPE, (String)(traceId + " not found"));
        }
        return ZipkinQueryApiV2.jsonResponse((byte[])SpanBytesEncoder.JSON_V2.encodeList(trace));
    }

    @Get(value="/api/v2/traceMany")
    @Blocking
    public AggregatedHttpResponse getTraces(@Param(value="traceIds") String traceIds) throws IOException {
        if (traceIds.isEmpty()) {
            return AggregatedHttpResponse.of((HttpStatus)HttpStatus.BAD_REQUEST, (MediaType)MediaType.ANY_TEXT_TYPE, (String)"traceIds parameter is empty");
        }
        LinkedHashSet<String> normalized = new LinkedHashSet<String>();
        for (String traceId : traceIds.split(",", 1000)) {
            if (normalized.add(Span.normalizeTraceId((String)traceId))) continue;
            return AggregatedHttpResponse.of((HttpStatus)HttpStatus.BAD_REQUEST, (MediaType)MediaType.ANY_TEXT_TYPE, (String)("redundant traceId: " + traceId));
        }
        if (normalized.size() == 1) {
            return AggregatedHttpResponse.of((HttpStatus)HttpStatus.BAD_REQUEST, (MediaType)MediaType.ANY_TEXT_TYPE, (String)"Use /api/v2/trace/{traceId} endpoint to retrieve a single trace");
        }
        List traces = (List)this.storage.traces().getTraces(normalized).execute();
        return ZipkinQueryApiV2.jsonResponse((byte[])ZipkinQueryApiV2.writeTraces((SpanBytesEncoder)SpanBytesEncoder.JSON_V2, (List)traces));
    }

    static AggregatedHttpResponse jsonResponse(byte[] body) {
        return AggregatedHttpResponse.of((ResponseHeaders)ResponseHeaders.builder((int)200).contentType(MediaType.JSON).setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, body.length).build(), (HttpData)HttpData.wrap((byte[])body));
    }

    @Get(value="/api/v2/autocompleteKeys")
    @Blocking
    public AggregatedHttpResponse getAutocompleteKeys() {
        return this.maybeCacheNames(true, this.autocompleteKeys);
    }

    @Get(value="/api/v2/autocompleteValues")
    @Blocking
    public AggregatedHttpResponse getAutocompleteValues(@Param(value="key") String key) throws IOException {
        List values = (List)this.storage.autocompleteTags().getValues(key).execute();
        return this.maybeCacheNames(values.size() > 3, values);
    }

    AggregatedHttpResponse maybeCacheNames(boolean shouldCacheControl, List<String> values) {
        Collections.sort(values);
        byte[] body = JsonCodec.writeList((WriteBuffer.Writer)QUOTED_STRING_WRITER, values);
        ResponseHeadersBuilder headers = ResponseHeaders.builder((int)200).contentType(MediaType.JSON).setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, body.length);
        if (shouldCacheControl) {
            headers = headers.add((CharSequence)HttpHeaderNames.CACHE_CONTROL, "max-age=" + this.namesMaxAge + ", must-revalidate");
        }
        return AggregatedHttpResponse.of((ResponseHeaders)headers.build(), (HttpData)HttpData.wrap((byte[])body));
    }

    static byte[] writeTraces(SpanBytesEncoder codec, List<List<Span>> traces) {
        int length = traces.size();
        int sizeInBytes = 2;
        if (length > 1) {
            sizeInBytes += length - 1;
        }
        for (int i = 0; i < length; ++i) {
            List<Span> spans = traces.get(i);
            int jLength = spans.size();
            sizeInBytes += 2;
            if (jLength > 1) {
                sizeInBytes += jLength - 1;
            }
            for (int j = 0; j < jLength; ++j) {
                sizeInBytes += codec.sizeInBytes((Object)spans.get(j));
            }
        }
        byte[] out = new byte[sizeInBytes];
        int pos = 0;
        out[pos++] = 91;
        for (int i = 0; i < length; ++i) {
            pos += codec.encodeList(traces.get(i), out, pos);
            if (i + 1 >= length) continue;
            out[pos++] = 44;
        }
        out[pos] = 93;
        return out;
    }
}

