/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal.brave;

import brave.Tracing;
import java.io.IOException;
import zipkin2.CheckResult;
import zipkin2.server.internal.brave.TracingStorageComponent;
import zipkin2.storage.AutocompleteTags;
import zipkin2.storage.ForwardingStorageComponent;
import zipkin2.storage.ServiceAndSpanNames;
import zipkin2.storage.SpanConsumer;
import zipkin2.storage.SpanStore;
import zipkin2.storage.StorageComponent;
import zipkin2.storage.Traces;

public final class TracingStorageComponent
extends ForwardingStorageComponent {
    final Tracing tracing;
    final StorageComponent delegate;

    public TracingStorageComponent(Tracing tracing, StorageComponent delegate) {
        this.tracing = tracing;
        this.delegate = delegate;
    }

    protected StorageComponent delegate() {
        return this.delegate;
    }

    public ServiceAndSpanNames serviceAndSpanNames() {
        return new TracingServiceAndSpanNames(this.tracing, this.delegate.serviceAndSpanNames());
    }

    public Traces traces() {
        return new TracingTraces(this.tracing, this.delegate.traces());
    }

    public SpanStore spanStore() {
        return new TracingSpanStore(this.tracing, this.delegate.spanStore());
    }

    public AutocompleteTags autocompleteTags() {
        return new TracingAutocompleteTags(this.tracing, this.delegate.autocompleteTags());
    }

    public SpanConsumer spanConsumer() {
        return new TracingSpanConsumer(this.tracing, this.delegate.spanConsumer());
    }

    public CheckResult check() {
        return this.delegate.check();
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public String toString() {
        return "Traced{" + this.delegate + "}";
    }
}

