/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal.elasticsearch;

import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.ClientOptions;
import com.linecorp.armeria.client.ClientOptionsBuilder;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.HttpClient;
import com.linecorp.armeria.client.encoding.HttpDecodingClient;
import com.linecorp.armeria.client.logging.LoggingClientBuilder;
import com.linecorp.armeria.client.metric.MetricCollectingClient;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.logging.LogLevel;
import com.linecorp.armeria.common.metric.MeterIdPrefixFunction;
import java.io.Closeable;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import zipkin2.server.internal.elasticsearch.HttpClientFactory;
import zipkin2.server.internal.elasticsearch.RawContentLoggingClient;
import zipkin2.server.internal.elasticsearch.ZipkinElasticsearchStorageProperties;

public class HttpClientFactory
implements Function<Endpoint, HttpClient>,
Closeable {
    final SessionProtocol protocol;
    final ClientOptions options;
    final ClientFactory delegate;
    final int timeout;
    final List<Consumer<ClientOptionsBuilder>> customizers;

    HttpClientFactory(ZipkinElasticsearchStorageProperties es, ClientFactory factory, SessionProtocol protocol, List<Consumer<ClientOptionsBuilder>> customizers) {
        this.delegate = factory;
        this.protocol = protocol;
        this.customizers = customizers;
        this.timeout = es.getTimeout();
        ZipkinElasticsearchStorageProperties.HttpLogging httpLogging = es.getHttpLogging();
        ClientOptionsBuilder options = (ClientOptionsBuilder)((ClientOptionsBuilder)new ClientOptionsBuilder().decorator(MetricCollectingClient.newDecorator((MeterIdPrefixFunction)MeterIdPrefixFunction.ofDefault((String)"elasticsearch")))).decorator(HttpDecodingClient.newDecorator());
        if (httpLogging != ZipkinElasticsearchStorageProperties.HttpLogging.NONE) {
            LoggingClientBuilder loggingBuilder = (LoggingClientBuilder)((LoggingClientBuilder)((LoggingClientBuilder)new LoggingClientBuilder().requestLogLevel(LogLevel.INFO)).successfulResponseLogLevel(LogLevel.INFO)).requestHeadersSanitizer(headers -> {
                if (!headers.contains((CharSequence)HttpHeaderNames.AUTHORIZATION)) {
                    return headers;
                }
                return headers.toBuilder().set((CharSequence)HttpHeaderNames.AUTHORIZATION, "****").build();
            });
            switch (1.$SwitchMap$zipkin2$server$internal$elasticsearch$ZipkinElasticsearchStorageProperties$HttpLogging[httpLogging.ordinal()]) {
                case 1: {
                    loggingBuilder.contentSanitizer(unused -> "");
                    break;
                }
                case 2: {
                    loggingBuilder.contentSanitizer(unused -> "");
                    loggingBuilder.headersSanitizer(unused -> HttpHeaders.of());
                    break;
                }
            }
            options.decorator(loggingBuilder.newDecorator());
            if (httpLogging == ZipkinElasticsearchStorageProperties.HttpLogging.BODY) {
                options.decorator(RawContentLoggingClient::new);
            }
        }
        this.options = this.configureOptionsExceptLogging(options).build();
    }

    @Override
    public HttpClient apply(Endpoint endpoint) {
        return HttpClient.of((ClientFactory)this.delegate, (SessionProtocol)this.protocol, (Endpoint)endpoint, (ClientOptions)this.options);
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    ClientOptionsBuilder configureOptionsExceptLogging(ClientOptionsBuilder options) {
        ((ClientOptionsBuilder)options.responseTimeoutMillis((long)this.timeout)).writeTimeoutMillis((long)this.timeout);
        this.customizers.forEach(c -> c.accept(options));
        return options;
    }
}

