/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal.elasticsearch;

import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.endpoint.dns.DnsAddressEndpointGroup;
import com.linecorp.armeria.common.SessionProtocol;
import java.net.URI;
import java.util.ArrayList;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zipkin2.Endpoint;
import zipkin2.internal.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
final class InitialEndpointSupplier
implements Supplier<EndpointGroup> {
    static final Logger LOGGER = LoggerFactory.getLogger(InitialEndpointSupplier.class);
    final String hosts;
    final SessionProtocol sessionProtocol;

    InitialEndpointSupplier(SessionProtocol sessionProtocol, @Nullable String hosts) {
        if (sessionProtocol == null) {
            throw new NullPointerException("sessionProtocol == null");
        }
        this.sessionProtocol = sessionProtocol;
        this.hosts = hosts == null || hosts.isEmpty() ? sessionProtocol.uriText() + "://localhost:9200" : hosts;
    }

    @Override
    public EndpointGroup get() {
        ArrayList<Object> endpointGroups = new ArrayList<Object>();
        for (String hostText : this.hosts.split(",", 100)) {
            URI url = hostText.startsWith("http://") || hostText.startsWith("https://") ? URI.create(hostText) : (!this.sessionProtocol.isTls() && hostText.indexOf(58) == -1 ? URI.create(this.sessionProtocol.uriText() + "://" + hostText + ":9200") : URI.create(this.sessionProtocol.uriText() + "://" + hostText));
            String host = url.getHost();
            int port = this.getPort(url);
            if (port == 9300) {
                LOGGER.warn("Native transport no longer supported. Changing {} to http port 9200", (Object)host);
                port = 9200;
            }
            if (InitialEndpointSupplier.isIpAddress((String)host) || host.equals("localhost")) {
                endpointGroups.add(EndpointGroup.of((EndpointGroup[])new EndpointGroup[]{com.linecorp.armeria.client.Endpoint.of((String)host, (int)port)}));
                continue;
            }
            endpointGroups.add(DnsAddressEndpointGroup.builder((String)host).port(port).build());
        }
        return EndpointGroup.of(endpointGroups);
    }

    int getPort(URI url) {
        int port = url.getPort();
        return port != -1 ? port : this.sessionProtocol.defaultPort();
    }

    static boolean isIpAddress(String address) {
        return Endpoint.newBuilder().parseIp(address);
    }

    public String toString() {
        return this.hosts;
    }
}

