/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal.mysql;

import brave.Span;
import brave.propagation.CurrentTraceContext;
import brave.propagation.ThreadLocalSpan;
import java.util.concurrent.Executor;
import org.jooq.ExecuteContext;
import org.jooq.ExecuteListener;
import org.jooq.ExecuteListenerProvider;
import org.jooq.impl.DefaultExecuteListener;
import org.jooq.impl.DefaultExecuteListenerProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import zipkin2.server.internal.ConditionalOnSelfTracing;
import zipkin2.server.internal.mysql.ZipkinMySQLStorageConfiguration;
import zipkin2.server.internal.mysql.ZipkinMySQLStorageProperties;
import zipkin2.server.internal.mysql.ZipkinSelfTracingMySQLStorageConfiguration;

/*
 * Exception performing whole class analysis ignored.
 */
@ConditionalOnSelfTracing
@ConditionalOnProperty(name={"zipkin.storage.type"}, havingValue="mysql")
class ZipkinSelfTracingMySQLStorageConfiguration
extends DefaultExecuteListener {
    @Autowired
    ZipkinMySQLStorageProperties mysql;
    @Autowired
    CurrentTraceContext currentTraceContext;
    @Autowired
    ThreadLocalSpan threadLocalSpan;

    ZipkinSelfTracingMySQLStorageConfiguration() {
    }

    @Bean
    ExecuteListenerProvider mysqlListener() {
        return new DefaultExecuteListenerProvider((ExecuteListener)this);
    }

    @Bean
    Executor mysqlExecutor() {
        return ZipkinSelfTracingMySQLStorageConfiguration.makeContextAware((Executor)new ZipkinMySQLStorageConfiguration().mysqlExecutor(), (CurrentTraceContext)this.currentTraceContext);
    }

    static Executor makeContextAware(Executor delegate, CurrentTraceContext currentTraceContext) {
        return new TracingCurrentRequestContextExecutor(delegate, currentTraceContext);
    }

    public void renderEnd(ExecuteContext ctx) {
        if (this.currentTraceContext.get() == null) {
            return;
        }
        Span span = this.threadLocalSpan.next();
        if (span == null || span.isNoop()) {
            return;
        }
        String sql = ctx.sql();
        int spaceIndex = sql.indexOf(32);
        span.kind(Span.Kind.CLIENT).name(spaceIndex == -1 ? sql : sql.substring(0, spaceIndex));
        span.tag("sql.query", sql);
        span.remoteServiceName("mysql");
        span.remoteIpAndPort(this.mysql.getHost(), this.mysql.getPort());
        span.start();
    }

    public void executeEnd(ExecuteContext ctx) {
        Span span = ThreadLocalSpan.CURRENT_TRACER.remove();
        if (span == null || span.isNoop()) {
            return;
        }
        if (ctx.sqlException() != null) {
            span.error((Throwable)ctx.sqlException());
        }
        span.finish();
    }
}

