/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal.throttle;

import com.linecorp.armeria.common.util.Exceptions;
import com.netflix.concurrency.limits.Limiter;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Predicate;
import zipkin2.Call;
import zipkin2.Callback;
import zipkin2.server.internal.throttle.LimiterMetrics;
import zipkin2.server.internal.throttle.ThrottledCall;

/*
 * Exception performing whole class analysis ignored.
 */
final class ThrottledCall
extends Call.Base<Void> {
    static final RejectedExecutionException STORAGE_THROTTLE_MAX_CONCURRENCY = (RejectedExecutionException)Exceptions.clearTrace((Throwable)new RejectedExecutionException("STORAGE_THROTTLE_MAX_CONCURRENCY reached"));
    static final Callback<Void> NOOP_CALLBACK = new /* Unavailable Anonymous Inner Class!! */;
    final Call<Void> delegate;
    final Executor executor;
    final Limiter<Void> limiter;
    final LimiterMetrics limiterMetrics;
    final Predicate<Throwable> isOverCapacity;
    final CountDownLatch latch = new CountDownLatch(1);
    Throwable throwable;

    ThrottledCall(Call<Void> delegate, Executor executor, Limiter<Void> limiter, LimiterMetrics limiterMetrics, Predicate<Throwable> isOverCapacity) {
        this.delegate = delegate;
        this.executor = executor;
        this.limiter = limiter;
        this.limiterMetrics = limiterMetrics;
        this.isOverCapacity = isOverCapacity;
    }

    protected Void doExecute() throws IOException {
        this.doEnqueue(NOOP_CALLBACK);
        if (!ThrottledCall.await((CountDownLatch)this.latch)) {
            throw new InterruptedIOException();
        }
        Throwable t = this.throwable;
        if (t == null) {
            return null;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new RuntimeException(t);
    }

    protected void doEnqueue(Callback<Void> callback) {
        Limiter.Listener limiterListener = (Limiter.Listener)this.limiter.acquire(null).orElseThrow(() -> STORAGE_THROTTLE_MAX_CONCURRENCY);
        this.limiterMetrics.requests.increment();
        EnqueueAndAwait enqueueAndAwait = new EnqueueAndAwait(this, callback, limiterListener);
        try {
            this.executor.execute((Runnable)enqueueAndAwait);
        }
        catch (Error | RuntimeException t) {
            ThrottledCall.propagateIfFatal((Throwable)t);
            callback.onError(t);
            limiterListener.onIgnore();
            throw t;
        }
    }

    public Call<Void> clone() {
        return new ThrottledCall(this.delegate.clone(), this.executor, this.limiter, this.limiterMetrics, this.isOverCapacity);
    }

    public String toString() {
        return "Throttled(" + this.delegate + ")";
    }

    static boolean await(CountDownLatch latch) {
        try {
            latch.await();
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }
}

