/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.collector.kafka08;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kafka.consumer.Consumer;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.KafkaStream;
import kafka.javaapi.consumer.ZookeeperConsumerConnector;
import zipkin2.CheckResult;
import zipkin2.collector.Collector;
import zipkin2.collector.CollectorComponent;
import zipkin2.collector.CollectorMetrics;
import zipkin2.collector.CollectorSampler;
import zipkin2.collector.kafka08.KafkaStreamProcessor;
import zipkin2.storage.StorageComponent;

public final class KafkaCollector
extends CollectorComponent {
    final LazyConnector connector;
    final LazyStreams streams;

    public static Builder builder() {
        return new Builder();
    }

    KafkaCollector(Builder builder) {
        this.connector = new LazyConnector(builder);
        this.streams = new LazyStreams(builder, this.connector);
    }

    public KafkaCollector start() {
        this.connector.get();
        this.streams.get();
        return this;
    }

    public CheckResult check() {
        try {
            this.connector.get();
            CheckResult failure = this.streams.failure.get();
            if (failure != null) {
                return failure;
            }
            return CheckResult.OK;
        }
        catch (RuntimeException e) {
            return CheckResult.failed((Throwable)e);
        }
    }

    public void close() {
        this.streams.close();
        this.connector.close();
    }

    static final class LazyStreams {
        final int streams;
        final String topic;
        final Collector collector;
        final CollectorMetrics metrics;
        final LazyConnector connector;
        final AtomicReference<CheckResult> failure = new AtomicReference();
        volatile ExecutorService pool;

        LazyStreams(Builder builder, LazyConnector connector) {
            this.streams = builder.streams;
            this.topic = builder.topic;
            this.collector = builder.delegate.build();
            this.metrics = builder.metrics;
            this.connector = connector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ExecutorService get() {
            if (this.pool == null) {
                LazyStreams lazyStreams = this;
                synchronized (lazyStreams) {
                    if (this.pool == null) {
                        this.pool = this.compute();
                    }
                }
            }
            return this.pool;
        }

        void close() {
            ExecutorService maybePool = this.pool;
            if (maybePool == null) {
                return;
            }
            maybePool.shutdownNow();
            try {
                maybePool.awaitTermination(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        ExecutorService compute() {
            ExecutorService pool = this.streams == 1 ? Executors.newSingleThreadExecutor() : Executors.newFixedThreadPool(this.streams);
            LinkedHashMap<String, Integer> topicCountMap = new LinkedHashMap<String, Integer>(1);
            topicCountMap.put(this.topic, this.streams);
            for (KafkaStream stream : (List)this.connector.get().createMessageStreams(topicCountMap).get(this.topic)) {
                pool.execute(this.guardFailures(new KafkaStreamProcessor((KafkaStream<byte[], byte[]>)stream, this.collector, this.metrics)));
            }
            return pool;
        }

        Runnable guardFailures(final Runnable delegate) {
            return new Runnable(){

                @Override
                public void run() {
                    try {
                        delegate.run();
                    }
                    catch (RuntimeException e) {
                        failure.set(CheckResult.failed((Throwable)e));
                    }
                }
            };
        }
    }

    static final class LazyConnector {
        final ConsumerConfig config;
        volatile ZookeeperConsumerConnector connector;

        LazyConnector(Builder builder) {
            this.config = new ConsumerConfig(builder.properties);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ZookeeperConsumerConnector get() {
            if (this.connector == null) {
                LazyConnector lazyConnector = this;
                synchronized (lazyConnector) {
                    if (this.connector == null) {
                        this.connector = (ZookeeperConsumerConnector)Consumer.createJavaConsumerConnector((ConsumerConfig)this.config);
                    }
                }
            }
            return this.connector;
        }

        void close() {
            ZookeeperConsumerConnector maybeConnector = this.connector;
            if (maybeConnector == null) {
                return;
            }
            maybeConnector.shutdown();
        }
    }

    public static final class Builder
    extends CollectorComponent.Builder {
        final Properties properties = new Properties();
        Collector.Builder delegate = Collector.newBuilder(KafkaCollector.class);
        CollectorMetrics metrics = CollectorMetrics.NOOP_METRICS;
        String topic = "zipkin";
        int streams = 1;

        public Builder storage(StorageComponent storage) {
            this.delegate.storage(storage);
            return this;
        }

        public Builder sampler(CollectorSampler sampler) {
            this.delegate.sampler(sampler);
            return this;
        }

        public Builder metrics(CollectorMetrics metrics) {
            if (metrics == null) {
                throw new NullPointerException("metrics == null");
            }
            this.metrics = metrics.forTransport("kafka");
            this.delegate.metrics(this.metrics);
            return this;
        }

        public Builder topic(String topic) {
            if (topic == null) {
                throw new NullPointerException("topic == null");
            }
            this.topic = topic;
            return this;
        }

        public Builder zookeeper(String zookeeper) {
            if (zookeeper == null) {
                throw new NullPointerException("zookeeper == null");
            }
            this.properties.put("zookeeper.connect", zookeeper);
            return this;
        }

        public Builder groupId(String groupId) {
            if (groupId == null) {
                throw new NullPointerException("groupId == null");
            }
            this.properties.put("group.id", groupId);
            return this;
        }

        public Builder streams(int streams) {
            this.streams = streams;
            return this;
        }

        public Builder maxMessageSize(int bytes) {
            this.properties.put("fetch.message.max.bytes", String.valueOf(bytes));
            return this;
        }

        public final Builder overrides(Map<String, ?> overrides) {
            if (overrides == null) {
                throw new NullPointerException("overrides == null");
            }
            this.properties.putAll(overrides);
            return this;
        }

        public KafkaCollector build() {
            return new KafkaCollector(this);
        }

        Builder() {
            this.properties.put("group.id", "zipkin");
            this.properties.put("fetch.message.max.bytes", String.valueOf(0x100000));
            this.properties.put("auto.offset.reset", "smallest");
        }
    }
}

