/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.collector.kafka08;

import java.util.Collections;
import kafka.consumer.ConsumerIterator;
import kafka.consumer.KafkaStream;
import zipkin2.Callback;
import zipkin2.Span;
import zipkin2.codec.SpanBytesDecoder;
import zipkin2.collector.Collector;
import zipkin2.collector.CollectorMetrics;

final class KafkaStreamProcessor
implements Runnable {
    static final Callback<Void> NOOP = new Callback<Void>(){

        public void onSuccess(Void value) {
        }

        public void onError(Throwable t) {
        }
    };
    final KafkaStream<byte[], byte[]> stream;
    final Collector collector;
    final CollectorMetrics metrics;

    KafkaStreamProcessor(KafkaStream<byte[], byte[]> stream, Collector collector, CollectorMetrics metrics) {
        this.stream = stream;
        this.collector = collector;
        this.metrics = metrics;
    }

    @Override
    public void run() {
        ConsumerIterator messages = this.stream.iterator();
        while (messages.hasNext()) {
            byte[] bytes = (byte[])messages.next().message();
            this.metrics.incrementMessages();
            if (bytes.length < 2) {
                this.metrics.incrementMessagesDropped();
                continue;
            }
            if (!KafkaStreamProcessor.protobuf3(bytes) && bytes[0] <= 16 && bytes[0] != 12) {
                try {
                    this.metrics.incrementBytes(bytes.length);
                    Span span = (Span)SpanBytesDecoder.THRIFT.decodeOne(bytes);
                    this.collector.accept(Collections.singletonList(span), NOOP);
                }
                catch (RuntimeException e) {
                    this.metrics.incrementMessagesDropped();
                }
                continue;
            }
            this.collector.acceptSpans(bytes, NOOP);
        }
    }

    static boolean protobuf3(byte[] bytes) {
        return bytes[0] == 10 && bytes[1] != 0;
    }
}

