/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.elasticsearch;

import com.squareup.moshi.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;
import zipkin2.Annotation;
import zipkin2.Call;
import zipkin2.Span;
import zipkin2.codec.SpanBytesEncoder;
import zipkin2.elasticsearch.ElasticsearchStorage;
import zipkin2.elasticsearch.internal.HttpBulkIndexer;
import zipkin2.elasticsearch.internal.IndexNameFormatter;
import zipkin2.elasticsearch.internal.client.HttpCall;
import zipkin2.storage.SpanConsumer;

class ElasticsearchSpanConsumer
implements SpanConsumer {
    static final Logger LOG = Logger.getLogger(ElasticsearchSpanConsumer.class.getName());
    private static final int INDEX_CHARS_LIMIT = 256;
    final ElasticsearchStorage es;

    ElasticsearchSpanConsumer(ElasticsearchStorage es) {
        this.es = es;
    }

    public Call<Void> accept(List<Span> spans) {
        if (spans.isEmpty()) {
            return Call.create(null);
        }
        BulkSpanIndexer indexer = new BulkSpanIndexer(this.es);
        this.indexSpans(indexer, spans);
        return indexer.newCall();
    }

    void indexSpans(BulkSpanIndexer indexer, List<Span> spans) {
        for (Span span : spans) {
            long spanTimestamp = span.timestampAsLong();
            long indexTimestamp = 0L;
            if (spanTimestamp != 0L) {
                indexTimestamp = spanTimestamp = TimeUnit.MICROSECONDS.toMillis(spanTimestamp);
            } else {
                int i = 0;
                int length = span.annotations().size();
                if (i < length) {
                    indexTimestamp = ((Annotation)span.annotations().get(i)).timestamp() / 1000L;
                }
                if (indexTimestamp == 0L) {
                    indexTimestamp = System.currentTimeMillis();
                }
            }
            indexer.add(indexTimestamp, span, spanTimestamp);
        }
    }

    static byte[] prefixWithTimestampMillisAndQuery(Span span, long timestampMillis) {
        Buffer query = new Buffer();
        JsonWriter writer = JsonWriter.of((BufferedSink)query);
        try {
            writer.beginObject();
            if (timestampMillis != 0L) {
                writer.name("timestamp_millis").value(timestampMillis);
            }
            if (!span.tags().isEmpty() || !span.annotations().isEmpty()) {
                writer.name("_q");
                writer.beginArray();
                for (Annotation annotation : span.annotations()) {
                    if (annotation.value().length() > 256) continue;
                    writer.value(annotation.value());
                }
                for (Map.Entry entry : span.tags().entrySet()) {
                    int length = ((String)entry.getKey()).length() + ((String)entry.getValue()).length() + 1;
                    if (length > 256) continue;
                    writer.value((String)entry.getKey());
                    writer.value(new StringBuilder(length).append((String)entry.getKey()).append("=").append((String)entry.getValue()).toString());
                }
                writer.endArray();
            }
            writer.endObject();
        }
        catch (IOException e) {
            assert (false) : "Error indexing query for span: " + span;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Error indexing query for span: " + span, e);
            }
            return SpanBytesEncoder.JSON_V2.encode((Object)span);
        }
        byte[] document = SpanBytesEncoder.JSON_V2.encode((Object)span);
        if (query.rangeEquals(0L, ByteString.of((byte[])new byte[]{123, 125}))) {
            return document;
        }
        byte[] byArray = query.readByteArray();
        byte[] newSpanBytes = new byte[byArray.length + document.length - 1];
        int pos = 0;
        System.arraycopy(byArray, 0, newSpanBytes, pos, byArray.length);
        newSpanBytes[(pos += byArray.length) - 1] = 44;
        System.arraycopy(document, 1, newSpanBytes, pos, document.length - 1);
        return newSpanBytes;
    }

    static final class BulkSpanIndexer {
        final HttpBulkIndexer indexer;
        final IndexNameFormatter indexNameFormatter;
        final boolean searchEnabled;

        BulkSpanIndexer(ElasticsearchStorage es) {
            this.indexer = new HttpBulkIndexer("index-span", es);
            this.indexNameFormatter = es.indexNameFormatter();
            this.searchEnabled = es.searchEnabled();
        }

        void add(long indexTimestamp, Span span, long timestampMillis) {
            String index = this.indexNameFormatter.formatTypeAndTimestamp("span", indexTimestamp);
            byte[] document = this.searchEnabled ? ElasticsearchSpanConsumer.prefixWithTimestampMillisAndQuery(span, timestampMillis) : SpanBytesEncoder.JSON_V2.encode((Object)span);
            this.indexer.add(index, "span", document, null);
        }

        HttpCall<Void> newCall() {
            return this.indexer.newCall();
        }
    }
}

