/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.storage.mysql.v1;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Row3;
import org.jooq.SelectConditionStep;
import org.jooq.SelectOffsetStep;
import org.jooq.TableLike;
import org.jooq.TableOnConditionStep;
import org.jooq.impl.DSL;
import zipkin2.Endpoint;
import zipkin2.Span;
import zipkin2.internal.Nullable;
import zipkin2.storage.QueryRequest;
import zipkin2.storage.mysql.v1.MySQLSpanConsumer;
import zipkin2.storage.mysql.v1.Pair;
import zipkin2.storage.mysql.v1.Schema;
import zipkin2.storage.mysql.v1.internal.generated.tables.ZipkinAnnotations;
import zipkin2.storage.mysql.v1.internal.generated.tables.ZipkinSpans;
import zipkin2.v1.V1Span;
import zipkin2.v1.V1SpanConverter;

abstract class SelectSpansAndAnnotations
implements Function<DSLContext, List<Span>> {
    final Schema schema;

    SelectSpansAndAnnotations(Schema schema) {
        this.schema = schema;
    }

    abstract Condition traceIdCondition(DSLContext var1);

    @Override
    public List<Span> apply(DSLContext context) {
        Map spansWithoutAnnotations = context.select(this.schema.spanFields).from((TableLike)ZipkinSpans.ZIPKIN_SPANS).where(this.traceIdCondition(context)).stream().map(r -> V1Span.newBuilder().traceIdHigh(Schema.maybeGet(r, ZipkinSpans.ZIPKIN_SPANS.TRACE_ID_HIGH, 0L).longValue()).traceId(((Long)r.getValue(ZipkinSpans.ZIPKIN_SPANS.TRACE_ID)).longValue()).name((String)r.getValue(ZipkinSpans.ZIPKIN_SPANS.NAME)).id(((Long)r.getValue(ZipkinSpans.ZIPKIN_SPANS.ID)).longValue()).parentId(Schema.maybeGet(r, ZipkinSpans.ZIPKIN_SPANS.PARENT_ID, 0L).longValue()).timestamp(Schema.maybeGet(r, ZipkinSpans.ZIPKIN_SPANS.START_TS, 0L).longValue()).duration(Schema.maybeGet(r, ZipkinSpans.ZIPKIN_SPANS.DURATION, 0L).longValue()).debug((Boolean)r.getValue(ZipkinSpans.ZIPKIN_SPANS.DEBUG))).collect(Collectors.groupingBy(s -> new Pair(s.traceIdHigh(), s.traceId()), LinkedHashMap::new, Collectors.toList()));
        Map dbAnnotations = context.select(this.schema.annotationFields).from((TableLike)ZipkinAnnotations.ZIPKIN_ANNOTATIONS).where(this.schema.annotationsTraceIdCondition(spansWithoutAnnotations.keySet())).orderBy((OrderField)ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_TIMESTAMP.asc(), (OrderField)ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_KEY.asc()).stream().collect(Collectors.groupingBy(a -> DSL.row((Object)Schema.maybeGet(a, ZipkinAnnotations.ZIPKIN_ANNOTATIONS.TRACE_ID_HIGH, 0L), (Object)((Long)a.getValue(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.TRACE_ID)), (Object)((Long)a.getValue(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.SPAN_ID))), LinkedHashMap::new, Collectors.toList()));
        V1SpanConverter converter = V1SpanConverter.create();
        ArrayList<Span> allSpans = new ArrayList<Span>(spansWithoutAnnotations.size());
        for (List spans : spansWithoutAnnotations.values()) {
            for (V1Span.Builder span : spans) {
                Row3 key = DSL.row((Object)span.traceIdHigh(), (Object)span.traceId(), (Object)span.id());
                if (dbAnnotations.containsKey(key)) {
                    for (Record a2 : (List)dbAnnotations.get(key)) {
                        Endpoint endpoint = SelectSpansAndAnnotations.endpoint(a2);
                        SelectSpansAndAnnotations.processAnnotationRecord(a2, span, endpoint);
                    }
                }
                converter.convert(span.build(), allSpans);
            }
        }
        return allSpans;
    }

    static void processAnnotationRecord(Record a, V1Span.Builder span, @Nullable Endpoint endpoint) {
        Integer type = (Integer)a.getValue(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_TYPE);
        if (type == null) {
            return;
        }
        if (type == -1) {
            span.addAnnotation(((Long)a.getValue(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_TIMESTAMP)).longValue(), (String)a.getValue(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_KEY), endpoint);
        } else {
            switch (type) {
                case 6: {
                    span.addBinaryAnnotation((String)a.getValue(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_KEY), new String((byte[])a.getValue(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_VALUE), MySQLSpanConsumer.UTF_8), endpoint);
                    break;
                }
                case 0: {
                    byte[] value;
                    String aKey;
                    if (endpoint == null || !(aKey = (String)a.getValue(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_KEY)).equals("sa") && !aKey.equals("ca") && !aKey.equals("ma") || (value = (byte[])a.getValue(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_VALUE)) == null || value.length != 1 || value[0] != 1) break;
                    span.addBinaryAnnotation((String)a.getValue(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_KEY), endpoint);
                    break;
                }
            }
        }
    }

    SelectOffsetStep<? extends Record> toTraceIdQuery(DSLContext context, QueryRequest request) {
        long endTs = request.endTs() * 1000L;
        TableOnConditionStep<?> table = ZipkinSpans.ZIPKIN_SPANS.join((TableLike)ZipkinAnnotations.ZIPKIN_ANNOTATIONS).on(this.schema.joinCondition(ZipkinAnnotations.ZIPKIN_ANNOTATIONS));
        int i = 0;
        for (Map.Entry kv : request.annotationQuery().entrySet()) {
            ZipkinAnnotations aTable = ZipkinAnnotations.ZIPKIN_ANNOTATIONS.as("a" + i++);
            if (((String)kv.getValue()).isEmpty()) {
                table = SelectSpansAndAnnotations.maybeOnService((TableOnConditionStep<Record>)table.join((TableLike)aTable).on(this.schema.joinCondition(aTable)).and(aTable.A_KEY.eq((Object)((String)kv.getKey()))), aTable, request.serviceName());
                continue;
            }
            table = SelectSpansAndAnnotations.maybeOnService((TableOnConditionStep<Record>)table.join((TableLike)aTable).on(this.schema.joinCondition(aTable)).and(aTable.A_TYPE.eq((Object)6)).and(aTable.A_KEY.eq((Object)((String)kv.getKey()))).and(aTable.A_VALUE.eq((Object)((String)kv.getValue()).getBytes(MySQLSpanConsumer.UTF_8))), aTable, request.serviceName());
        }
        ArrayList distinctFields = new ArrayList(this.schema.spanIdFields);
        distinctFields.add(ZipkinSpans.ZIPKIN_SPANS.START_TS.max());
        SelectConditionStep dsl = context.selectDistinct(distinctFields).from((TableLike)table).where(ZipkinSpans.ZIPKIN_SPANS.START_TS.between((Object)(endTs - request.lookback() * 1000L), (Object)endTs));
        if (request.serviceName() != null) {
            dsl.and(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_SERVICE_NAME.eq((Object)request.serviceName()));
        }
        if (request.spanName() != null) {
            dsl.and(ZipkinSpans.ZIPKIN_SPANS.NAME.eq((Object)request.spanName()));
        }
        if (request.minDuration() != null && request.maxDuration() != null) {
            dsl.and(ZipkinSpans.ZIPKIN_SPANS.DURATION.between((Object)request.minDuration(), (Object)request.maxDuration()));
        } else if (request.minDuration() != null) {
            dsl.and(ZipkinSpans.ZIPKIN_SPANS.DURATION.greaterOrEqual((Object)request.minDuration()));
        }
        return dsl.groupBy(this.schema.spanIdFields).orderBy((OrderField)ZipkinSpans.ZIPKIN_SPANS.START_TS.max().desc()).limit(request.limit());
    }

    static TableOnConditionStep<?> maybeOnService(TableOnConditionStep<Record> table, ZipkinAnnotations aTable, String serviceName) {
        if (serviceName == null) {
            return table;
        }
        return table.and(aTable.ENDPOINT_SERVICE_NAME.eq((Object)serviceName));
    }

    static Endpoint endpoint(Record a) {
        Endpoint.Builder result = Endpoint.newBuilder().serviceName((String)a.getValue(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_SERVICE_NAME)).port((int)Schema.maybeGet(a, ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_PORT, (short)0).shortValue());
        int ipv4 = Schema.maybeGet(a, ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_IPV4, 0);
        if (ipv4 != 0) {
            result.parseIp(new byte[]{(byte)(ipv4 >> 24 & 0xFF), (byte)(ipv4 >> 16 & 0xFF), (byte)(ipv4 >> 8 & 0xFF), (byte)(ipv4 & 0xFF)});
        }
        result.parseIp((byte[])Schema.maybeGet(a, ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_IPV6, null));
        return result.build();
    }

    static final class Factory {
        final Schema schema;
        final boolean strictTraceId;

        Factory(Schema schema, boolean strictTraceId) {
            this.schema = schema;
            this.strictTraceId = strictTraceId;
        }

        SelectSpansAndAnnotations create(long traceIdHigh, final long traceIdLow) {
            if (traceIdHigh != 0L && !this.strictTraceId) {
                traceIdHigh = 0L;
            }
            final long finalTraceIdHigh = traceIdHigh;
            return new SelectSpansAndAnnotations(this.schema){

                @Override
                Condition traceIdCondition(DSLContext context) {
                    return this.schema.spanTraceIdCondition(finalTraceIdHigh, traceIdLow);
                }
            };
        }

        SelectSpansAndAnnotations create(final QueryRequest request) {
            return new SelectSpansAndAnnotations(this.schema){

                @Override
                Condition traceIdCondition(DSLContext context) {
                    return this.schema.spanTraceIdCondition(this.toTraceIdQuery(context, request));
                }
            };
        }
    }
}

