/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.storage.mysql.v1;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.jooq.DSLContext;
import org.jooq.TableLike;
import org.jooq.exception.DataAccessException;
import zipkin2.storage.mysql.v1.DSLContexts;
import zipkin2.storage.mysql.v1.internal.generated.tables.ZipkinDependencies;

final class HasErrorCount {
    private static final Logger LOG = Logger.getLogger(HasErrorCount.class.getName());

    HasErrorCount() {
    }

    static boolean test(DataSource datasource, DSLContexts context) {
        block11: {
            boolean bl;
            block10: {
                Connection conn = datasource.getConnection();
                try {
                    DSLContext dsl = context.get(conn);
                    dsl.select(ZipkinDependencies.ZIPKIN_DEPENDENCIES.ERROR_COUNT).from((TableLike)ZipkinDependencies.ZIPKIN_DEPENDENCIES).limit(1).fetchAny();
                    bl = true;
                    if (conn == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (conn != null) {
                            try {
                                conn.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (DataAccessException e) {
                        if (e.sqlState().equals("42S22")) {
                            LOG.warning("zipkin_dependencies.error_count doesn't exist, so DependencyLink.errorCount is not supported. Execute: alter table zipkin_dependencies add `error_count` BIGINT");
                            return false;
                        }
                        HasErrorCount.problemReading((Exception)((Object)e));
                        break block11;
                    }
                    catch (RuntimeException | SQLException e) {
                        HasErrorCount.problemReading(e);
                    }
                }
                conn.close();
            }
            return bl;
        }
        return false;
    }

    static void problemReading(Exception e) {
        LOG.log(Level.WARNING, "problem reading zipkin_dependencies.error_count", e);
    }
}

