/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.storage.mysql.v1;

import java.util.List;
import java.util.function.Function;
import org.jooq.DSLContext;
import org.jooq.TableLike;
import zipkin2.DependencyLink;
import zipkin2.internal.DependencyLinker;
import zipkin2.storage.mysql.v1.Schema;
import zipkin2.storage.mysql.v1.internal.generated.tables.ZipkinDependencies;

final class SelectDependencies
implements Function<DSLContext, List<DependencyLink>> {
    final Schema schema;
    final List<Long> epochDays;

    SelectDependencies(Schema schema, List<Long> epochDays) {
        this.schema = schema;
        this.epochDays = epochDays;
    }

    @Override
    public List<DependencyLink> apply(DSLContext context) {
        List unmerged = context.select(this.schema.dependencyLinkFields).from((TableLike)ZipkinDependencies.ZIPKIN_DEPENDENCIES).where(ZipkinDependencies.ZIPKIN_DEPENDENCIES.DAY.in(this.epochDays)).fetch(l -> DependencyLink.newBuilder().parent((String)l.get(ZipkinDependencies.ZIPKIN_DEPENDENCIES.PARENT)).child((String)l.get(ZipkinDependencies.ZIPKIN_DEPENDENCIES.CHILD)).callCount(((Long)l.get(ZipkinDependencies.ZIPKIN_DEPENDENCIES.CALL_COUNT)).longValue()).errorCount(Schema.maybeGet(l, ZipkinDependencies.ZIPKIN_DEPENDENCIES.ERROR_COUNT, 0L).longValue()).build());
        return DependencyLinker.merge((Iterable)unmerged);
    }

    public String toString() {
        return "SelectDependencies{epochDays=" + this.epochDays + "}";
    }
}

