/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.storage.mysql.v1;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jooq.DSLContext;
import org.jooq.InsertReturningStep;
import org.jooq.InsertSetMoreStep;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.TableField;
import zipkin2.Call;
import zipkin2.Endpoint;
import zipkin2.Span;
import zipkin2.internal.Nullable;
import zipkin2.storage.SpanConsumer;
import zipkin2.storage.mysql.v1.DataSourceCall;
import zipkin2.storage.mysql.v1.Schema;
import zipkin2.storage.mysql.v1.internal.generated.tables.ZipkinAnnotations;
import zipkin2.storage.mysql.v1.internal.generated.tables.ZipkinSpans;
import zipkin2.v1.V1Annotation;
import zipkin2.v1.V1BinaryAnnotation;
import zipkin2.v1.V1Span;
import zipkin2.v1.V2SpanConverter;

final class MySQLSpanConsumer
implements SpanConsumer {
    static final byte[] ONE = new byte[]{1};
    final DataSourceCall.Factory dataSourceCallFactory;
    final Schema schema;

    MySQLSpanConsumer(DataSourceCall.Factory dataSourceCallFactory, Schema schema) {
        this.dataSourceCallFactory = dataSourceCallFactory;
        this.schema = schema;
    }

    public Call<Void> accept(List<Span> spans) {
        if (spans.isEmpty()) {
            return Call.create(null);
        }
        return this.dataSourceCallFactory.create(new BatchInsertSpans(spans, this.schema));
    }

    static void updateName(@Nullable String name, TableField<Record, String> column, InsertSetMoreStep<Record> insertSpan, Map<TableField<Record, ?>, Object> updateFields) {
        if (name != null && !name.equals("unknown")) {
            insertSpan.set(column, (Object)name);
            updateFields.put(column, name);
        } else {
            insertSpan.set(column, (Object)"");
        }
    }

    static final class BatchInsertSpans
    implements Function<DSLContext, Void> {
        final List<Span> spans;
        final Schema schema;

        BatchInsertSpans(List<Span> spans, Schema schema) {
            this.spans = spans;
            this.schema = schema;
        }

        @Override
        public Void apply(DSLContext create) {
            ArrayList<InsertReturningStep> inserts = new ArrayList<InsertReturningStep>();
            V2SpanConverter v2SpanConverter = V2SpanConverter.create();
            for (Span v2 : this.spans) {
                InsertSetMoreStep insert;
                long traceIdHigh;
                long duration;
                Endpoint ep = v2.localEndpoint();
                long timestamp = v2.timestampAsLong();
                V1Span v1Span = v2SpanConverter.convert(v2);
                long traceId = v1Span.traceId();
                long spanId = v1Span.id();
                InsertSetMoreStep insertSpan = create.insertInto((Table)ZipkinSpans.ZIPKIN_SPANS).set(ZipkinSpans.ZIPKIN_SPANS.TRACE_ID, (Object)traceId).set(ZipkinSpans.ZIPKIN_SPANS.ID, (Object)spanId).set(ZipkinSpans.ZIPKIN_SPANS.DEBUG, (Object)v1Span.debug());
                LinkedHashMap updateFields = new LinkedHashMap();
                if (timestamp != 0L) {
                    insertSpan.set(ZipkinSpans.ZIPKIN_SPANS.START_TS, (Object)timestamp);
                    if (!Boolean.TRUE.equals(v2.shared())) {
                        updateFields.put(ZipkinSpans.ZIPKIN_SPANS.START_TS, timestamp);
                    }
                }
                MySQLSpanConsumer.updateName(v1Span.name(), ZipkinSpans.ZIPKIN_SPANS.NAME, (InsertSetMoreStep<Record>)insertSpan, updateFields);
                if (this.schema.hasRemoteServiceName) {
                    MySQLSpanConsumer.updateName(v2.remoteServiceName(), ZipkinSpans.ZIPKIN_SPANS.REMOTE_SERVICE_NAME, (InsertSetMoreStep<Record>)insertSpan, updateFields);
                }
                if ((duration = v1Span.duration()) != 0L) {
                    insertSpan.set(ZipkinSpans.ZIPKIN_SPANS.DURATION, (Object)duration);
                    updateFields.put(ZipkinSpans.ZIPKIN_SPANS.DURATION, duration);
                }
                if (v1Span.parentId() != 0L) {
                    insertSpan.set(ZipkinSpans.ZIPKIN_SPANS.PARENT_ID, (Object)v1Span.parentId());
                    updateFields.put(ZipkinSpans.ZIPKIN_SPANS.PARENT_ID, v1Span.parentId());
                }
                long l = traceIdHigh = this.schema.hasTraceIdHigh ? v1Span.traceIdHigh() : 0L;
                if (traceIdHigh != 0L) {
                    insertSpan.set(ZipkinSpans.ZIPKIN_SPANS.TRACE_ID_HIGH, (Object)traceIdHigh);
                }
                inserts.add((InsertReturningStep)(updateFields.isEmpty() ? insertSpan.onDuplicateKeyIgnore() : insertSpan.onDuplicateKeyUpdate().set(updateFields)));
                int ipv4 = ep != null && ep.ipv4Bytes() != null ? ByteBuffer.wrap(ep.ipv4Bytes()).getInt() : 0;
                for (V1Annotation a : v1Span.annotations()) {
                    insert = create.insertInto((Table)ZipkinAnnotations.ZIPKIN_ANNOTATIONS).set(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.TRACE_ID, (Object)traceId).set(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.SPAN_ID, (Object)spanId).set(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_KEY, (Object)a.value()).set(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_TYPE, (Object)-1).set(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_TIMESTAMP, (Object)a.timestamp());
                    if (traceIdHigh != 0L) {
                        insert.set(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.TRACE_ID_HIGH, (Object)traceIdHigh);
                    }
                    this.addEndpoint((InsertSetMoreStep<Record>)insert, ep, ipv4);
                    inserts.add(insert.onDuplicateKeyIgnore());
                }
                for (V1BinaryAnnotation ba : v1Span.binaryAnnotations()) {
                    insert = create.insertInto((Table)ZipkinAnnotations.ZIPKIN_ANNOTATIONS).set(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.TRACE_ID, (Object)traceId).set(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.SPAN_ID, (Object)spanId).set(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_KEY, (Object)ba.key()).set(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_TYPE, (Object)ba.type()).set(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_TIMESTAMP, (Object)timestamp);
                    if (traceIdHigh != 0L) {
                        insert.set(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.TRACE_ID_HIGH, (Object)traceIdHigh);
                    }
                    if (ba.stringValue() != null) {
                        insert.set(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_VALUE, (Object)ba.stringValue().getBytes(StandardCharsets.UTF_8));
                        this.addEndpoint((InsertSetMoreStep<Record>)insert, ep, ipv4);
                    } else {
                        insert.set(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_VALUE, (Object)ONE);
                        Endpoint nextEp = ba.endpoint();
                        this.addEndpoint((InsertSetMoreStep<Record>)insert, nextEp, nextEp.ipv4Bytes() != null ? ByteBuffer.wrap(nextEp.ipv4Bytes()).getInt() : 0);
                    }
                    inserts.add(insert.onDuplicateKeyIgnore());
                }
            }
            create.batch(inserts).execute();
            return null;
        }

        void addEndpoint(InsertSetMoreStep<Record> insert, Endpoint ep, int ipv4) {
            if (ep == null) {
                return;
            }
            String serviceName = ep.serviceName() != null ? ep.serviceName() : "";
            insert.set(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_SERVICE_NAME, (Object)serviceName);
            if (ipv4 != 0) {
                insert.set(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_IPV4, (Object)ipv4);
            }
            if (ep.ipv6Bytes() != null && this.schema.hasIpv6) {
                insert.set(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_IPV6, (Object)ep.ipv6Bytes());
            }
            if (ep.portAsInt() != 0) {
                insert.set(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_PORT, (Object)((short)ep.portAsInt()));
            }
        }

        public String toString() {
            return "BatchInsertSpansAndAnnotations{spans=" + this.spans + "}";
        }
    }
}

