/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.storage.mysql.v1;

import java.util.List;
import java.util.function.Function;
import org.jooq.DSLContext;
import org.jooq.TableLike;
import zipkin2.storage.mysql.v1.Schema;
import zipkin2.storage.mysql.v1.SelectAnnotationServiceNames;
import zipkin2.storage.mysql.v1.internal.generated.tables.ZipkinAnnotations;
import zipkin2.storage.mysql.v1.internal.generated.tables.ZipkinSpans;

final class SelectRemoteServiceNames
implements Function<DSLContext, List<String>> {
    final Schema schema;
    final String serviceName;

    SelectRemoteServiceNames(Schema schema, String serviceName) {
        this.schema = schema;
        this.serviceName = serviceName;
    }

    @Override
    public List<String> apply(DSLContext context) {
        return context.selectDistinct(ZipkinSpans.ZIPKIN_SPANS.REMOTE_SERVICE_NAME).from((TableLike)ZipkinSpans.ZIPKIN_SPANS).join((TableLike)ZipkinAnnotations.ZIPKIN_ANNOTATIONS).on(this.schema.joinCondition(ZipkinAnnotations.ZIPKIN_ANNOTATIONS)).where(SelectAnnotationServiceNames.localServiceNameCondition().and(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_SERVICE_NAME.eq((Object)this.serviceName))).and(ZipkinSpans.ZIPKIN_SPANS.REMOTE_SERVICE_NAME.notEqual((Object)"")).orderBy(ZipkinSpans.ZIPKIN_SPANS.REMOTE_SERVICE_NAME).fetch(ZipkinSpans.ZIPKIN_SPANS.REMOTE_SERVICE_NAME);
    }

    public String toString() {
        return "SelectRemoteServiceNames{serviceName=" + this.serviceName + "}";
    }
}

