/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.storage.mysql.v1;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.jooq.Condition;
import org.jooq.Cursor;
import org.jooq.DSLContext;
import org.jooq.TableLike;
import zipkin2.DependencyLink;
import zipkin2.internal.DependencyLinker;
import zipkin2.storage.mysql.v1.DependencyLinkV2SpanIterator;
import zipkin2.storage.mysql.v1.Schema;
import zipkin2.storage.mysql.v1.internal.generated.tables.ZipkinAnnotations;
import zipkin2.storage.mysql.v1.internal.generated.tables.ZipkinSpans;

final class AggregateDependencies
implements Function<DSLContext, List<DependencyLink>> {
    final Schema schema;
    final long startTsBegin;
    final long startTsEnd;

    AggregateDependencies(Schema schema, long startTsBegin, long startTsEnd) {
        this.schema = schema;
        this.startTsBegin = startTsBegin;
        this.startTsEnd = startTsEnd;
    }

    @Override
    public List<DependencyLink> apply(DSLContext context) {
        Cursor cursor = context.selectDistinct(this.schema.dependencyLinkerFields).from((TableLike)ZipkinSpans.ZIPKIN_SPANS.leftJoin((TableLike)ZipkinAnnotations.ZIPKIN_ANNOTATIONS).on(new Condition[]{ZipkinSpans.ZIPKIN_SPANS.TRACE_ID.eq(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.TRACE_ID).and(ZipkinSpans.ZIPKIN_SPANS.ID.eq(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.SPAN_ID))}).and(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_KEY.in((Object[])new String[]{"lc", "cs", "ca", "sr", "sa", "error"}))).where(new Condition[]{this.startTsBegin == this.startTsEnd ? ZipkinSpans.ZIPKIN_SPANS.START_TS.lessOrEqual((Object)this.startTsEnd) : ZipkinSpans.ZIPKIN_SPANS.START_TS.between((Object)this.startTsBegin, (Object)this.startTsEnd)}).groupBy(this.schema.dependencyLinkerGroupByFields).fetchLazy();
        DependencyLinkV2SpanIterator.ByTraceId traces = new DependencyLinkV2SpanIterator.ByTraceId(cursor.iterator(), this.schema.hasTraceIdHigh);
        if (!traces.hasNext()) {
            return Collections.emptyList();
        }
        DependencyLinker linker = new DependencyLinker();
        while (traces.hasNext()) {
            linker.putTrace((Iterator)traces.next());
        }
        return linker.link();
    }

    public String toString() {
        return "AggregateDependencies{startTsBegin=" + this.startTsBegin + ", startTsEnd=" + this.startTsEnd + '}';
    }
}

