/*
 * Decompiled with CFR 0.152.
 */
package io.zksync;

import io.zksync.abi.TransactionEncoder;
import io.zksync.crypto.eip712.Eip712Domain;
import io.zksync.crypto.signer.EthSigner;
import io.zksync.crypto.signer.PrivateKeyEthSigner;
import io.zksync.methods.request.Transaction;
import io.zksync.methods.response.ZksBridgeAddresses;
import io.zksync.protocol.ZkSync;
import io.zksync.protocol.core.BridgeAddresses;
import io.zksync.protocol.core.Token;
import io.zksync.protocol.core.ZkBlockParameterName;
import io.zksync.protocol.exceptions.JsonRpcResponseException;
import io.zksync.transaction.fee.DefaultTransactionFeeProvider;
import io.zksync.transaction.fee.ZkTransactionFeeProvider;
import io.zksync.transaction.response.ZkSyncTransactionReceiptProcessor;
import io.zksync.transaction.type.Transaction712;
import io.zksync.wrappers.ERC20;
import io.zksync.wrappers.IL2Messenger;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.Nullable;
import org.web3j.abi.FunctionEncoder;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.transaction.type.ITransaction;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.Response;
import org.web3j.protocol.core.methods.response.EthGetBalance;
import org.web3j.protocol.core.methods.response.EthGetTransactionCount;
import org.web3j.protocol.core.methods.response.EthSendTransaction;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.protocol.exceptions.TransactionException;
import org.web3j.tx.ReadonlyTransactionManager;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;
import org.web3j.tx.gas.DefaultGasProvider;
import org.web3j.tx.response.TransactionReceiptProcessor;
import org.web3j.utils.Numeric;

public class ZkSyncWallet {
    private final ZkSync zksync;
    private final EthSigner signer;
    private final TransactionReceiptProcessor transactionReceiptProcessor;
    private final ZkTransactionFeeProvider feeProvider;

    public ZkSyncWallet(ZkSync zksync, EthSigner signer, TransactionReceiptProcessor transactionReceiptProcessor, ZkTransactionFeeProvider feeProvider) {
        this.zksync = zksync;
        this.signer = signer;
        this.transactionReceiptProcessor = transactionReceiptProcessor;
        this.feeProvider = feeProvider;
    }

    public ZkSyncWallet(ZkSync zksync, EthSigner signer) {
        this(zksync, signer, new ZkSyncTransactionReceiptProcessor(zksync, 800L, 40), new DefaultTransactionFeeProvider(zksync, Token.ETH));
    }

    public ZkSyncWallet(ZkSync zksync, EthSigner signer, Token feeToken) {
        this(zksync, signer, new ZkSyncTransactionReceiptProcessor(zksync, 800L, 40), new DefaultTransactionFeeProvider(zksync, feeToken));
    }

    public ZkSyncWallet(ZkSync zksync, Credentials credentials, Long chainId) {
        this(zksync, new PrivateKeyEthSigner(credentials, chainId));
    }

    public RemoteCall<TransactionReceipt> transfer(String to, BigInteger amount) {
        return this.transfer(to, amount, null, null);
    }

    public RemoteCall<TransactionReceipt> transfer(String to, BigInteger amount, Token token) {
        return this.transfer(to, amount, token, null);
    }

    public RemoteCall<TransactionReceipt> transfer(String to, BigInteger amount, @Nullable Token token, @Nullable BigInteger nonce) {
        BigInteger txAmount;
        String txTo;
        String calldata;
        Token tokenToUse;
        Token token2 = tokenToUse = token == null ? Token.ETH : token;
        if (tokenToUse.isETH()) {
            calldata = "0x";
            txTo = to;
            txAmount = amount;
        } else {
            Function function = ERC20.encodeTransfer(to, amount);
            calldata = FunctionEncoder.encode((Function)function);
            txTo = tokenToUse.getL2Address();
            txAmount = null;
        }
        return new RemoteCall(() -> {
            BigInteger nonceToUse = nonce != null ? nonce : (BigInteger)this.getNonce().send();
            Transaction estimate = Transaction.createFunctionCallTransaction(this.signer.getAddress(), txTo, BigInteger.ZERO, BigInteger.ZERO, txAmount, calldata);
            EthSendTransaction sent = this.estimateAndSend(estimate, nonceToUse).join();
            try {
                return this.transactionReceiptProcessor.waitForTransactionReceipt(sent.getTransactionHash());
            }
            catch (IOException | TransactionException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public RemoteCall<TransactionReceipt> withdraw(String to, BigInteger amount) {
        return this.withdraw(to, amount, null, null);
    }

    public RemoteCall<TransactionReceipt> withdraw(String to, BigInteger amount, Token token) {
        return this.withdraw(to, amount, token, null);
    }

    public RemoteCall<TransactionReceipt> withdraw(String to, BigInteger amount, @Nullable Token token, @Nullable BigInteger nonce) {
        Token tokenToUse = token == null ? Token.ETH : token;
        return new RemoteCall(() -> {
            String l2Bridge;
            BigInteger nonceToUse = nonce != null ? nonce : (BigInteger)this.getNonce().send();
            ArrayList<Object> parameters = new ArrayList<Object>();
            parameters.add(new Address(to));
            if (tokenToUse.isETH()) {
                l2Bridge = "0x000000000000000000000000000000000000800a";
            } else {
                parameters.add(new Address(tokenToUse.getL2Address()));
                parameters.add(new Uint256(amount));
                l2Bridge = ((BridgeAddresses)((ZksBridgeAddresses)this.zksync.zksGetBridgeContracts().send()).getResult()).getL2Erc20DefaultBridge();
            }
            Function function = new Function("withdraw", parameters, Collections.emptyList());
            String calldata = FunctionEncoder.encode((Function)function);
            Transaction estimate = Transaction.createFunctionCallTransaction(this.signer.getAddress(), l2Bridge, BigInteger.ZERO, BigInteger.ZERO, calldata);
            EthSendTransaction sent = this.estimateAndSend(estimate, nonceToUse).join();
            try {
                return this.transactionReceiptProcessor.waitForTransactionReceipt(sent.getTransactionHash());
            }
            catch (IOException | TransactionException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public RemoteCall<TransactionReceipt> deploy(byte[] bytecode) {
        return this.deploy(bytecode, null, null);
    }

    public RemoteCall<TransactionReceipt> deploy(byte[] bytecode, byte[] calldata) {
        return this.deploy(bytecode, calldata, null);
    }

    public RemoteCall<TransactionReceipt> deploy(byte[] bytecode, @Nullable byte[] calldata, @Nullable BigInteger nonce) {
        return new RemoteCall(() -> {
            BigInteger nonceToUse = nonce != null ? nonce : (BigInteger)this.getNonce().send();
            Transaction estimate = Transaction.createContractTransaction(this.signer.getAddress(), BigInteger.ZERO, BigInteger.ZERO, Numeric.toHexString((byte[])bytecode), calldata != null ? Numeric.toHexString((byte[])calldata) : "0x");
            EthSendTransaction sent = this.estimateAndSend(estimate, nonceToUse).join();
            try {
                return this.transactionReceiptProcessor.waitForTransactionReceipt(sent.getTransactionHash());
            }
            catch (IOException | TransactionException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public RemoteCall<TransactionReceipt> execute(String contractAddress, Function function) {
        return this.execute(contractAddress, function, null);
    }

    public RemoteCall<TransactionReceipt> execute(String contractAddress, Function function, @Nullable BigInteger nonce) {
        return new RemoteCall(() -> {
            BigInteger nonceToUse = nonce != null ? nonce : (BigInteger)this.getNonce().send();
            String calldata = FunctionEncoder.encode((Function)function);
            Transaction estimate = Transaction.createFunctionCallTransaction(this.signer.getAddress(), contractAddress, BigInteger.ZERO, BigInteger.ZERO, calldata);
            EthSendTransaction sent = this.estimateAndSend(estimate, nonceToUse).join();
            try {
                return this.transactionReceiptProcessor.waitForTransactionReceipt(sent.getTransactionHash());
            }
            catch (IOException | TransactionException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public RemoteCall<BigInteger> getBalance() {
        return this.getBalance(this.signer.getAddress(), Token.ETH, ZkBlockParameterName.COMMITTED);
    }

    public RemoteCall<BigInteger> getBalance(Token token) {
        return this.getBalance(this.signer.getAddress(), token, ZkBlockParameterName.COMMITTED);
    }

    public RemoteCall<BigInteger> getBalance(String address) {
        return this.getBalance(address, Token.ETH, ZkBlockParameterName.COMMITTED);
    }

    public RemoteCall<BigInteger> getBalance(String address, Token token) {
        return this.getBalance(address, token, ZkBlockParameterName.COMMITTED);
    }

    public RemoteCall<BigInteger> getBalance(String address, Token token, DefaultBlockParameter at) {
        if (token.isETH()) {
            return new RemoteCall(() -> ((EthGetBalance)this.zksync.ethGetBalance(address, at).sendAsync().join()).getBalance());
        }
        ERC20 erc20 = ERC20.load(token.getL2Address(), (Web3j)this.zksync, (TransactionManager)new ReadonlyTransactionManager((Web3j)this.zksync, this.getSigner().getAddress()), (ContractGasProvider)new DefaultGasProvider());
        return erc20.balanceOf(address);
    }

    public RemoteCall<BigInteger> getNonce(DefaultBlockParameter at) {
        return new RemoteCall(() -> ((EthGetTransactionCount)this.zksync.ethGetTransactionCount(this.signer.getAddress(), at).sendAsync().join()).getTransactionCount());
    }

    public RemoteCall<BigInteger> getNonce() {
        return this.getNonce(ZkBlockParameterName.COMMITTED);
    }

    public RemoteCall<TransactionReceipt> sendMessageToL1(byte[] message) {
        return this.sendMessageToL1(message, null);
    }

    public RemoteCall<TransactionReceipt> sendMessageToL1(byte[] message, @Nullable BigInteger nonce) {
        return new RemoteCall(() -> {
            BigInteger nonceToUse = nonce != null ? nonce : (BigInteger)this.getNonce().send();
            String calldata = FunctionEncoder.encode((Function)IL2Messenger.encodeSendToL1(message));
            Transaction estimate = Transaction.createFunctionCallTransaction(this.signer.getAddress(), "0x0000000000000000000000000000000000008008", BigInteger.ZERO, BigInteger.ZERO, calldata);
            EthSendTransaction sent = this.estimateAndSend(estimate, nonceToUse).join();
            try {
                return this.transactionReceiptProcessor.waitForTransactionReceipt(sent.getTransactionHash());
            }
            catch (IOException | TransactionException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private CompletableFuture<EthSendTransaction> estimateAndSend(Transaction transaction, BigInteger nonce) {
        return CompletableFuture.supplyAsync(() -> {
            long chainId = this.signer.getDomain().join().getChainId().getValue().longValue();
            BigInteger gas = this.getFeeProvider().getGasLimit(transaction);
            BigInteger gasPrice = this.getFeeProvider().getGasPrice();
            Transaction712 prepared = new Transaction712(chainId, nonce, gas, transaction.getTo(), transaction.getValueNumber(), transaction.getData(), BigInteger.valueOf(100000000L), gasPrice, transaction.getFrom(), transaction.getEip712Meta());
            String signature = (String)((CompletableFuture)this.signer.getDomain().thenCompose(domain -> this.signer.signTypedData((Eip712Domain)domain, prepared))).join();
            byte[] signed = TransactionEncoder.encode((ITransaction)prepared, TransactionEncoder.getSignatureData(signature));
            return (EthSendTransaction)this.zksync.ethSendRawTransaction(Numeric.toHexString((byte[])signed)).sendAsync().join();
        }).thenApply(response -> {
            if (response.hasError()) {
                throw new JsonRpcResponseException((Response<?>)response);
            }
            return response;
        });
    }

    public ZkSync getZksync() {
        return this.zksync;
    }

    public EthSigner getSigner() {
        return this.signer;
    }

    public TransactionReceiptProcessor getTransactionReceiptProcessor() {
        return this.transactionReceiptProcessor;
    }

    public ZkTransactionFeeProvider getFeeProvider() {
        return this.feeProvider;
    }
}

