/*
 * Decompiled with CFR 0.152.
 */
package io.zksync.abi;

import io.zksync.crypto.eip712.Eip712Domain;
import io.zksync.crypto.signer.PrivateKeyEthSigner;
import io.zksync.transaction.type.Transaction712;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.Sign;
import org.web3j.crypto.transaction.type.ITransaction;
import org.web3j.crypto.transaction.type.TransactionType;
import org.web3j.rlp.RlpEncoder;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpType;
import org.web3j.utils.Numeric;

public class TransactionEncoder
extends org.web3j.crypto.TransactionEncoder {
    public static Sign.SignatureData getSignatureData(String signature) {
        byte[] signatureRaw = Numeric.hexStringToByteArray((String)signature);
        return new Sign.SignatureData(Arrays.copyOfRange(signatureRaw, 64, signatureRaw.length), Arrays.copyOfRange(signatureRaw, 0, 32), Arrays.copyOfRange(signatureRaw, 32, 64));
    }

    public static Sign.SignatureData signMessage(Transaction712 transactionRequest, Eip712Domain domain, Credentials credentials) {
        PrivateKeyEthSigner signer = new PrivateKeyEthSigner(credentials, domain);
        String signature = signer.signTypedData(domain, transactionRequest).join();
        return TransactionEncoder.getSignatureData(signature);
    }

    public static byte[] encode(ITransaction rawTransaction, Sign.SignatureData signatureData) {
        List values = rawTransaction.asRlpValues(signatureData);
        RlpList rlpList = new RlpList(values);
        byte[] encoded = RlpEncoder.encode((RlpType)rlpList);
        if (!rawTransaction.getType().equals((Object)TransactionType.LEGACY)) {
            return ByteBuffer.allocate(encoded.length + 1).put(rawTransaction.getType().getRlpType()).put(encoded).array();
        }
        if (rawTransaction instanceof Transaction712) {
            return ByteBuffer.allocate(encoded.length + 1).put((byte)113).put(encoded).array();
        }
        return encoded;
    }
}

