/*
 * Decompiled with CFR 0.152.
 */
package io.zksync.abi;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.web3j.abi.FunctionEncoder;
import org.web3j.abi.TypeEncoder;
import org.web3j.abi.Utils;
import org.web3j.abi.datatypes.DynamicArray;
import org.web3j.abi.datatypes.DynamicBytes;
import org.web3j.abi.datatypes.DynamicStruct;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.StaticArray;
import org.web3j.abi.datatypes.StaticStruct;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Uint;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.utils.Numeric;

public class ZkFunctionEncoder
extends FunctionEncoder {
    private static final int ABI_OFFSET_CALL_RETURN_DATA = 8;
    private static final int ABI_OFFSET_RETURN_DATA_SIZE = 1;
    private static final int ABI_OFFSET_CALLDATA_SIZE = 0;
    private static final int ABI_MEMORY_DATA_OFFSET = 1;
    private static final int ABI_MEMORY_HEADER_OFFSET = 0;
    private static final int ABI_OFFSET_ENTRY_HASH = 7;
    private static final int FIELD_SIZE = 32;

    public String encodeFunction(Function function) {
        List parameters = function.getInputParameters();
        String methodSignature = ZkFunctionEncoder.buildMethodSignature((String)function.getName(), (List)parameters);
        String methodId = ZkFunctionEncoder.buildMethodId((String)methodSignature);
        StringBuilder result = new StringBuilder();
        result.append(methodId);
        return ZkFunctionEncoder.encodeParameters(parameters, result);
    }

    public String encodeParameters(List<Type> parameters) {
        return ZkFunctionEncoder.encodeParameters(parameters, new StringBuilder());
    }

    protected String encodeWithSelector(String methodId, List<Type> parameters) {
        StringBuilder result = new StringBuilder(methodId);
        return ZkFunctionEncoder.encodeParameters(parameters, result);
    }

    protected String encodePackedParameters(List<Type> parameters) {
        StringBuilder result = new StringBuilder();
        for (Type parameter : parameters) {
            result.append(TypeEncoder.encodePacked((Type)parameter));
        }
        return result.toString();
    }

    public static byte[] encodeConstructor(byte[] calldata) {
        int constructorDataOffset;
        int size = calldata.length;
        if (size % 32 != 0) {
            int offset = 32 - size % 32;
            int newLength = size + offset;
            calldata = Arrays.copyOf(calldata, newLength);
        }
        byte[] result = new byte[32 + calldata.length];
        int calldataOffset = 0;
        byte[] calldataSize = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(size).array();
        System.arraycopy(calldataSize, 0, result, calldataOffset, 4);
        int n = constructorDataOffset = 8;
        result[n] = (byte)(result[n] | 1);
        for (int i = 0; i < calldata.length; i += 32) {
            ArrayUtils.reverse((byte[])calldata, (int)i, (int)Math.min(calldata.length, i + 32));
        }
        System.arraycopy(calldata, 0, result, 32, calldata.length);
        return result;
    }

    public static byte[] encodeCalldata(Function function) {
        byte[] calldata = Numeric.hexStringToByteArray((String)FunctionEncoder.encode((Function)function));
        int calldataSize = function.getInputParameters().size();
        int returndataSize = function.getOutputParameters().size();
        int size = (8 + calldataSize) * 32;
        boolean calldataSizeOffset = false;
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(0, calldataSize);
        int returndataSizeOffset = 32;
        buffer.putInt(32, returndataSize);
        int constructorCalllOffset = 224;
        buffer.put(224, (byte)0);
        int entryHashOffset = 252;
        byte[] selector = ArrayUtils.subarray((byte[])calldata, (int)0, (int)4);
        ArrayUtils.reverse((byte[])selector);
        for (int i = 0; i < 4; ++i) {
            buffer.put(252 + i, selector[i]);
        }
        int calldataOffset = 256;
        for (Type value : function.getInputParameters()) {
            String result = TypeEncoder.encode((Type)value);
            byte[] encoded = Numeric.hexStringToByteArray((String)result);
            ArrayUtils.reverse((byte[])encoded);
            for (int i = 0; i < encoded.length; ++i) {
                buffer.put(calldataOffset + i, encoded[i]);
            }
            calldataOffset += 32;
        }
        return buffer.array();
    }

    private static String encodeParameters(List<Type> parameters, StringBuilder result) {
        int dynamicDataOffset = ZkFunctionEncoder.getLength(parameters) * 32;
        StringBuilder dynamicData = new StringBuilder();
        for (Type parameter : parameters) {
            String encodedValue = TypeEncoder.encode((Type)parameter);
            if (ZkFunctionEncoder.isDynamic(parameter)) {
                String encodedDataOffset = TypeEncoder.encode((Type)new Uint(BigInteger.valueOf(dynamicDataOffset)));
                result.append(encodedDataOffset);
                dynamicData.append(encodedValue);
                dynamicDataOffset += encodedValue.length() >> 1;
                continue;
            }
            result.append(encodedValue);
        }
        result.append((CharSequence)dynamicData);
        return result.toString();
    }

    private static int getLength(List<Type> parameters) {
        int count = 0;
        for (Type type : parameters) {
            if (type instanceof StaticArray && StaticStruct.class.isAssignableFrom(((StaticArray)type).getComponentType())) {
                count += Utils.staticStructNestedPublicFieldsFlatList((Class)((StaticArray)type).getComponentType()).size() * ((StaticArray)type).getValue().size();
                continue;
            }
            if (type instanceof StaticArray && DynamicStruct.class.isAssignableFrom(((StaticArray)type).getComponentType())) {
                ++count;
                continue;
            }
            if (type instanceof StaticStruct) {
                count += ZkFunctionEncoder.getLength(((StaticStruct)type).getValue());
                continue;
            }
            if (type instanceof StaticArray) {
                count += ((StaticArray)type).getValue().size();
                continue;
            }
            ++count;
        }
        return count;
    }

    static boolean isDynamic(Type parameter) {
        return parameter instanceof DynamicBytes || parameter instanceof Utf8String || parameter instanceof DynamicArray || parameter instanceof StaticArray && DynamicStruct.class.isAssignableFrom(((StaticArray)parameter).getComponentType());
    }
}

