/*
 * Decompiled with CFR 0.152.
 */
package io.zksync.crypto.eip712;

import io.zksync.crypto.eip712.Structurable;
import io.zksync.protocol.core.ZkSyncNetwork;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.abi.datatypes.generated.Uint256;

public class Eip712Domain
implements Structurable {
    public static final String NAME = "zkSync";
    public static final String VERSION = "2";
    private Utf8String name;
    private Utf8String version;
    private Uint256 chainId;
    private Address verifyingContract;

    public static Eip712Domain defaultDomain(ZkSyncNetwork chainId) {
        return new Eip712Domain(new Utf8String(NAME), new Utf8String(VERSION), new Uint256(chainId.getChainId()), null);
    }

    public static Eip712Domain defaultDomain(Long chainId) {
        return new Eip712Domain(new Utf8String(NAME), new Utf8String(VERSION), new Uint256(chainId.longValue()), null);
    }

    public Eip712Domain(String name, String version, Long chainId) {
        this(new Utf8String(name), new Utf8String(version), new Uint256(chainId.longValue()), null);
    }

    public Eip712Domain(String name, String version, ZkSyncNetwork chainId, String address) {
        this(new Utf8String(name), new Utf8String(version), new Uint256(chainId.getChainId()), new Address(address));
    }

    public Eip712Domain(String name, String version, Long chainId, String address) {
        this(new Utf8String(name), new Utf8String(version), new Uint256(chainId.longValue()), new Address(address));
    }

    @Override
    public String getTypeName() {
        return "EIP712Domain";
    }

    @Override
    public List<Pair<String, Type<?>>> eip712types() {
        return new ArrayList<Pair<String, Type<?>>>(){
            {
                this.add(Pair.of((Object)"name", (Object)Eip712Domain.this.name));
                this.add(Pair.of((Object)"version", (Object)Eip712Domain.this.version));
                this.add(Pair.of((Object)"chainId", (Object)Eip712Domain.this.chainId));
                if (Eip712Domain.this.verifyingContract != null) {
                    this.add(Pair.of((Object)"verifyingContract", (Object)Eip712Domain.this.verifyingContract));
                }
            }
        };
    }

    public Utf8String getName() {
        return this.name;
    }

    public Utf8String getVersion() {
        return this.version;
    }

    public Uint256 getChainId() {
        return this.chainId;
    }

    public Address getVerifyingContract() {
        return this.verifyingContract;
    }

    public void setName(Utf8String name) {
        this.name = name;
    }

    public void setVersion(Utf8String version) {
        this.version = version;
    }

    public void setChainId(Uint256 chainId) {
        this.chainId = chainId;
    }

    public void setVerifyingContract(Address verifyingContract) {
        this.verifyingContract = verifyingContract;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Eip712Domain)) {
            return false;
        }
        Eip712Domain other = (Eip712Domain)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Utf8String this$name = this.getName();
        Utf8String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Utf8String this$version = this.getVersion();
        Utf8String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        Uint256 this$chainId = this.getChainId();
        Uint256 other$chainId = other.getChainId();
        if (this$chainId == null ? other$chainId != null : !this$chainId.equals(other$chainId)) {
            return false;
        }
        Address this$verifyingContract = this.getVerifyingContract();
        Address other$verifyingContract = other.getVerifyingContract();
        return !(this$verifyingContract == null ? other$verifyingContract != null : !this$verifyingContract.equals(other$verifyingContract));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Eip712Domain;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Utf8String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Utf8String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        Uint256 $chainId = this.getChainId();
        result = result * 59 + ($chainId == null ? 43 : $chainId.hashCode());
        Address $verifyingContract = this.getVerifyingContract();
        result = result * 59 + ($verifyingContract == null ? 43 : $verifyingContract.hashCode());
        return result;
    }

    public String toString() {
        return "Eip712Domain(name=" + this.getName() + ", version=" + this.getVersion() + ", chainId=" + this.getChainId() + ", verifyingContract=" + this.getVerifyingContract() + ")";
    }

    public Eip712Domain(Utf8String name, Utf8String version, Uint256 chainId, Address verifyingContract) {
        this.name = name;
        this.version = version;
        this.chainId = chainId;
        this.verifyingContract = verifyingContract;
    }
}

