/*
 * Decompiled with CFR 0.152.
 */
package io.zksync.crypto.eip712;

import io.zksync.crypto.eip712.Eip712Domain;
import io.zksync.crypto.eip712.Eip712Struct;
import io.zksync.crypto.eip712.Structurable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.tuple.Pair;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.BytesType;
import org.web3j.abi.datatypes.DynamicArray;
import org.web3j.abi.datatypes.NumericType;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.abi.datatypes.generated.Bytes32;
import org.web3j.crypto.Hash;
import org.web3j.utils.Numeric;

public class Eip712Encoder {
    public static Bytes32 encodeValue(Type<?> value) {
        if (value instanceof Utf8String) {
            Utf8String s = (Utf8String)value;
            return new Bytes32(Hash.sha3((byte[])s.getValue().getBytes()));
        }
        if (value instanceof Bytes32) {
            return (Bytes32)value;
        }
        if (value instanceof NumericType) {
            NumericType nt = (NumericType)value;
            return new Bytes32(Numeric.toBytesPadded((BigInteger)nt.getValue(), (int)32));
        }
        if (value instanceof DynamicArray) {
            List members = ((DynamicArray)value).getValue();
            ByteBuffer bytes = ByteBuffer.allocate(members.size() * 32);
            members.stream().map(Eip712Encoder::encodeValue).forEach(bytes32 -> bytes.put(bytes32.getValue()));
            return new Bytes32(Hash.sha3((byte[])bytes.array()));
        }
        if (value instanceof BytesType) {
            BytesType bt = (BytesType)value;
            byte[] bytes = Hash.sha3((byte[])bt.getValue());
            return new Bytes32(bytes);
        }
        if (value instanceof Address) {
            Address address = (Address)value;
            byte[] bytes = Numeric.hexStringToByteArray((String)address.getValue());
            byte[] result = new byte[32];
            System.arraycopy(bytes, 0, result, 12, 20);
            return new Bytes32(result);
        }
        if (value instanceof Eip712Struct) {
            Eip712Struct struct = (Eip712Struct)value;
            byte[] typeHash = Eip712Encoder.typeHash(struct);
            List<Pair<String, Type<?>>> members = struct.getValue().eip712types();
            ByteBuffer bytes = ByteBuffer.allocate((members.size() + 1) * 32);
            bytes.put(typeHash);
            for (Pair<String, Type<?>> member : members) {
                Bytes32 result = Eip712Encoder.encodeValue((Type)member.getValue());
                bytes.put(result.getValue());
            }
            return new Bytes32(Hash.sha3((byte[])bytes.array()));
        }
        throw new IllegalArgumentException(String.format("Unsupported ethereum type: \"%s\"", value.getTypeAsString()));
    }

    public static String encodeType(Eip712Struct structure) {
        StringBuilder sb = new StringBuilder(structure.encodeType());
        Eip712Encoder.dependencies(structure).forEach(value -> sb.append(value.encodeType()));
        return sb.toString();
    }

    public static byte[] typeHash(Eip712Struct structure) {
        return Hash.sha3((byte[])Eip712Encoder.encodeType(structure).getBytes());
    }

    public static Set<Eip712Struct> dependencies(Eip712Struct structure) {
        TreeSet<Eip712Struct> result = new TreeSet<Eip712Struct>();
        for (Pair<String, Type<?>> value : structure.getValue().eip712types()) {
            if (!(value.getValue() instanceof Eip712Struct)) continue;
            result.add((Eip712Struct)value.getValue());
        }
        return result;
    }

    public static <S extends Structurable> byte[] typedDataToSignedBytes(Eip712Domain domain, S typedData) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            output.write("\u0019\u0001".getBytes());
            output.write(Eip712Encoder.encodeValue(domain.intoEip712Struct()).getValue());
            output.write(Eip712Encoder.encodeValue(typedData.intoEip712Struct()).getValue());
        }
        catch (IOException e) {
            throw new IllegalStateException("Error when creating ETH signature", e);
        }
        return Hash.sha3((byte[])output.toByteArray());
    }
}

