/*
 * Decompiled with CFR 0.152.
 */
package io.zksync.crypto.signer;

import io.zksync.crypto.eip712.Eip712Domain;
import io.zksync.crypto.eip712.Structurable;
import java.util.concurrent.CompletableFuture;
import org.web3j.crypto.Hash;
import org.web3j.utils.Numeric;

public interface EthSigner {
    public static final String MESSAGE_PREFIX = "\u0019Ethereum Signed Message:\n";
    public static final String MESSAGE_EIP712_PREFIX = "\u0019\u0001";
    public static final byte[] EIP1271_SUCCESS_VALUE = Numeric.hexStringToByteArray((String)"0x1626ba7e");

    public String getAddress();

    public CompletableFuture<Eip712Domain> getDomain();

    public <S extends Structurable> CompletableFuture<String> signTypedData(Eip712Domain var1, S var2);

    public <S extends Structurable> CompletableFuture<Boolean> verifyTypedData(Eip712Domain var1, S var2, String var3);

    public CompletableFuture<String> signMessage(byte[] var1);

    public CompletableFuture<String> signMessage(byte[] var1, boolean var2);

    public CompletableFuture<Boolean> verifySignature(String var1, byte[] var2);

    public CompletableFuture<Boolean> verifySignature(String var1, byte[] var2, boolean var3);

    public static byte[] getEthereumMessagePrefix(int messageLength) {
        return MESSAGE_PREFIX.concat(String.valueOf(messageLength)).getBytes();
    }

    public static byte[] getEthereumMessageHash(byte[] message) {
        byte[] prefix = EthSigner.getEthereumMessagePrefix(message.length);
        byte[] result = new byte[prefix.length + message.length];
        System.arraycopy(prefix, 0, result, 0, prefix.length);
        System.arraycopy(message, 0, result, prefix.length, message.length);
        return Hash.sha3((byte[])result);
    }
}

