/*
 * Decompiled with CFR 0.152.
 */
package io.zksync.crypto.signer;

import io.zksync.crypto.eip712.Eip712Domain;
import io.zksync.crypto.eip712.Eip712Encoder;
import io.zksync.crypto.eip712.Structurable;
import io.zksync.crypto.signer.EthSigner;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import org.web3j.crypto.Bip32ECKeyPair;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.ECDSASignature;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Keys;
import org.web3j.crypto.MnemonicUtils;
import org.web3j.crypto.Sign;
import org.web3j.utils.Numeric;

public class PrivateKeyEthSigner
implements EthSigner {
    private Credentials credentials;
    private Eip712Domain domain;

    public PrivateKeyEthSigner(Credentials credentials, long chainId) {
        this.credentials = credentials;
        this.domain = Eip712Domain.defaultDomain(chainId);
    }

    public static PrivateKeyEthSigner fromMnemonic(String mnemonic, long chainId) {
        Credentials credentials = PrivateKeyEthSigner.generateCredentialsFromMnemonic(mnemonic, 0);
        return new PrivateKeyEthSigner(credentials, chainId);
    }

    public static PrivateKeyEthSigner fromMnemonic(String mnemonic, int accountIndex, long chainId) {
        Credentials credentials = PrivateKeyEthSigner.generateCredentialsFromMnemonic(mnemonic, accountIndex);
        return new PrivateKeyEthSigner(credentials, chainId);
    }

    @Override
    public String getAddress() {
        return this.credentials.getAddress();
    }

    @Override
    public CompletableFuture<Eip712Domain> getDomain() {
        return CompletableFuture.completedFuture(this.domain);
    }

    @Override
    public <S extends Structurable> CompletableFuture<String> signTypedData(Eip712Domain domain, S typedData) {
        return this.signMessage(Eip712Encoder.typedDataToSignedBytes(domain, typedData), false);
    }

    @Override
    public <S extends Structurable> CompletableFuture<Boolean> verifyTypedData(Eip712Domain domain, S typedData, String signature) {
        return this.verifySignature(signature, Eip712Encoder.typedDataToSignedBytes(domain, typedData), false);
    }

    @Override
    public CompletableFuture<String> signMessage(byte[] message) {
        return this.signMessage(message, true);
    }

    @Override
    public CompletableFuture<String> signMessage(byte[] message, boolean addPrefix) {
        Sign.SignatureData sig = addPrefix ? Sign.signPrefixedMessage((byte[])message, (ECKeyPair)this.credentials.getEcKeyPair()) : Sign.signMessage((byte[])message, (ECKeyPair)this.credentials.getEcKeyPair(), (boolean)false);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            output.write(sig.getR());
            output.write(sig.getS());
            output.write(sig.getV());
        }
        catch (IOException e) {
            throw new IllegalStateException("Error when creating ETH signature", e);
        }
        String signature = Numeric.toHexString((byte[])output.toByteArray());
        return CompletableFuture.completedFuture(signature);
    }

    @Override
    public CompletableFuture<Boolean> verifySignature(String signature, byte[] message) {
        return this.verifySignature(signature, message, true);
    }

    @Override
    public CompletableFuture<Boolean> verifySignature(String signature, byte[] message, boolean prefixed) {
        byte[] messageHash = prefixed ? EthSigner.getEthereumMessageHash(message) : message;
        String address = PrivateKeyEthSigner.ecrecover(Numeric.hexStringToByteArray((String)signature), messageHash);
        return CompletableFuture.completedFuture(address.equalsIgnoreCase(this.getAddress()));
    }

    private static String ecrecover(byte[] signature, byte[] hash) {
        ECDSASignature sig = new ECDSASignature(Numeric.toBigInt((byte[])Arrays.copyOfRange(signature, 0, 32)), Numeric.toBigInt((byte[])Arrays.copyOfRange(signature, 32, 64)));
        int v = signature[64];
        int recId = v >= 3 ? v - 27 : v;
        BigInteger recovered = Sign.recoverFromSignature((int)recId, (ECDSASignature)sig, (byte[])hash);
        return "0x" + Keys.getAddress((BigInteger)recovered);
    }

    private static Credentials generateCredentialsFromMnemonic(String mnemonic, int accountIndex) {
        int[] derivationPath = new int[]{-2147483604, -2147483588, Integer.MIN_VALUE, 0, accountIndex};
        Bip32ECKeyPair masterKeypair = Bip32ECKeyPair.generateKeyPair((byte[])MnemonicUtils.generateSeed((String)mnemonic, (String)""));
        Bip32ECKeyPair derivedKeyPair = Bip32ECKeyPair.deriveKeyPair((Bip32ECKeyPair)masterKeypair, (int[])derivationPath);
        return Credentials.create((ECKeyPair)derivedKeyPair);
    }

    public PrivateKeyEthSigner(Credentials credentials, Eip712Domain domain) {
        this.credentials = credentials;
        this.domain = domain;
    }
}

