/*
 * Decompiled with CFR 0.152.
 */
package io.zksync.methods.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.zksync.methods.request.PaymasterParams;
import io.zksync.utils.ByteArray2Serializer;
import io.zksync.utils.ByteArraySerializer;
import java.math.BigInteger;
import java.util.Arrays;
import org.web3j.utils.Numeric;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Eip712Meta {
    private BigInteger gasPerPubdata;
    private byte[] customSignature;
    private byte[][] factoryDeps;
    private PaymasterParams paymasterParams;

    public String getGasPerPubdata() {
        return Eip712Meta.convert(this.gasPerPubdata);
    }

    @JsonIgnore
    public BigInteger getGasPerPubdataNumber() {
        return this.gasPerPubdata;
    }

    @JsonSerialize(using=ByteArraySerializer.class)
    public byte[] getCustomSignature() {
        return this.customSignature;
    }

    @JsonSerialize(using=ByteArray2Serializer.class)
    public byte[][] getFactoryDeps() {
        return this.factoryDeps;
    }

    public PaymasterParams getPaymasterParams() {
        return this.paymasterParams;
    }

    private static String convert(BigInteger value) {
        if (value != null) {
            return Numeric.encodeQuantity((BigInteger)value);
        }
        return null;
    }

    public static Eip712MetaBuilder builder() {
        return new Eip712MetaBuilder();
    }

    public Eip712Meta() {
    }

    public Eip712Meta(BigInteger gasPerPubdata, byte[] customSignature, byte[][] factoryDeps, PaymasterParams paymasterParams) {
        this.gasPerPubdata = gasPerPubdata;
        this.customSignature = customSignature;
        this.factoryDeps = factoryDeps;
        this.paymasterParams = paymasterParams;
    }

    public void setGasPerPubdata(BigInteger gasPerPubdata) {
        this.gasPerPubdata = gasPerPubdata;
    }

    public void setCustomSignature(byte[] customSignature) {
        this.customSignature = customSignature;
    }

    public void setFactoryDeps(byte[][] factoryDeps) {
        this.factoryDeps = factoryDeps;
    }

    public void setPaymasterParams(PaymasterParams paymasterParams) {
        this.paymasterParams = paymasterParams;
    }

    public static class Eip712MetaBuilder {
        private BigInteger gasPerPubdata;
        private byte[] customSignature;
        private byte[][] factoryDeps;
        private PaymasterParams paymasterParams;

        Eip712MetaBuilder() {
        }

        public Eip712MetaBuilder gasPerPubdata(BigInteger gasPerPubdata) {
            this.gasPerPubdata = gasPerPubdata;
            return this;
        }

        public Eip712MetaBuilder customSignature(byte[] customSignature) {
            this.customSignature = customSignature;
            return this;
        }

        public Eip712MetaBuilder factoryDeps(byte[][] factoryDeps) {
            this.factoryDeps = factoryDeps;
            return this;
        }

        public Eip712MetaBuilder paymasterParams(PaymasterParams paymasterParams) {
            this.paymasterParams = paymasterParams;
            return this;
        }

        public Eip712Meta build() {
            return new Eip712Meta(this.gasPerPubdata, this.customSignature, this.factoryDeps, this.paymasterParams);
        }

        public String toString() {
            return "Eip712Meta.Eip712MetaBuilder(gasPerPubdata=" + this.gasPerPubdata + ", customSignature=" + Arrays.toString(this.customSignature) + ", factoryDeps=" + Arrays.deepToString((Object[])this.factoryDeps) + ", paymasterParams=" + this.paymasterParams + ")";
        }
    }
}

