/*
 * Decompiled with CFR 0.152.
 */
package io.zksync.methods.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.zksync.methods.request.Eip712Meta;
import io.zksync.methods.request.PaymasterParams;
import io.zksync.utils.ContractDeployer;
import java.math.BigInteger;
import java.util.List;
import org.web3j.abi.FunctionEncoder;
import org.web3j.abi.datatypes.Function;
import org.web3j.protocol.core.methods.response.AccessListObject;
import org.web3j.utils.Numeric;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Transaction {
    private String from;
    private String to;
    private BigInteger gas;
    private BigInteger gasPrice;
    private BigInteger value;
    private String data;
    private Long transactionType;
    private AccessListObject accessList;
    private Eip712Meta eip712Meta;

    public Transaction(String from, String to, BigInteger gas, BigInteger gasPrice, BigInteger value, String data, Eip712Meta eip712Meta) {
        this.from = from;
        this.to = to;
        this.gas = gas;
        this.gasPrice = gasPrice;
        this.value = value;
        this.data = data;
        this.eip712Meta = eip712Meta;
        this.transactionType = 113L;
    }

    public static Transaction createEtherTransaction(String from, BigInteger gasPrice, BigInteger gasLimit, String to, BigInteger value) {
        Eip712Meta meta = new Eip712Meta(BigInteger.valueOf(160000L), null, null, null);
        return new Transaction(from, to, gasPrice, gasLimit, value, "0x", meta);
    }

    public static Transaction create2ContractTransaction(String from, BigInteger gasPrice, BigInteger gasLimit, BigInteger value, String bytecode) {
        byte[] bytecodeBytes = Numeric.hexStringToByteArray((String)bytecode);
        String calldata = FunctionEncoder.encode((Function)ContractDeployer.encodeCreate2(bytecodeBytes));
        Eip712Meta meta = new Eip712Meta(BigInteger.valueOf(160000L), null, new byte[][]{bytecodeBytes}, null);
        return new Transaction(from, "0x0000000000000000000000000000000000008006", gasPrice, gasLimit, value, calldata, meta);
    }

    public static Transaction create2ContractTransaction(String from, BigInteger gasPrice, BigInteger gasLimit, String bytecode) {
        byte[] bytecodeBytes = Numeric.hexStringToByteArray((String)bytecode);
        String calldata = FunctionEncoder.encode((Function)ContractDeployer.encodeCreate2(bytecodeBytes));
        Eip712Meta meta = new Eip712Meta(BigInteger.valueOf(160000L), null, new byte[][]{bytecodeBytes}, null);
        return new Transaction(from, "0x0000000000000000000000000000000000008006", gasPrice, gasLimit, null, calldata, meta);
    }

    public static Transaction create2ContractTransaction(String from, BigInteger gasPrice, BigInteger gasLimit, String bytecode, String calldata) {
        byte[] bytecodeBytes = Numeric.hexStringToByteArray((String)bytecode);
        byte[] calldataBytes = Numeric.hexStringToByteArray((String)calldata);
        String calldataCreate = FunctionEncoder.encode((Function)ContractDeployer.encodeCreate2(bytecodeBytes, calldataBytes));
        Eip712Meta meta = new Eip712Meta(BigInteger.valueOf(160000L), null, new byte[][]{bytecodeBytes}, null);
        return new Transaction(from, "0x0000000000000000000000000000000000008006", gasPrice, gasLimit, null, calldataCreate, meta);
    }

    public static Transaction create2ContractTransaction(String from, BigInteger gasPrice, BigInteger gasLimit, String bytecode, String calldata, byte[] salt) {
        byte[] bytecodeBytes = Numeric.hexStringToByteArray((String)bytecode);
        byte[] calldataBytes = Numeric.hexStringToByteArray((String)calldata);
        String calldataCreate = FunctionEncoder.encode((Function)ContractDeployer.encodeCreate2(bytecodeBytes, calldataBytes, salt));
        Eip712Meta meta = new Eip712Meta(BigInteger.valueOf(160000L), null, new byte[][]{bytecodeBytes}, null);
        return new Transaction(from, "0x0000000000000000000000000000000000008006", gasPrice, gasLimit, null, calldataCreate, meta);
    }

    public static Transaction create2ContractTransaction(String from, BigInteger gasPrice, BigInteger gasLimit, String bytecode, List<String> deps, String calldata, byte[] salt) {
        byte[] bytecodeBytes = Numeric.hexStringToByteArray((String)bytecode);
        byte[] calldataBytes = Numeric.hexStringToByteArray((String)calldata);
        byte[][] factoryDeps = new byte[deps.size() + 1][];
        for (int i = 0; i < deps.size(); ++i) {
            factoryDeps[i] = Numeric.hexStringToByteArray((String)deps.get(i));
        }
        factoryDeps[deps.size()] = bytecodeBytes;
        String calldataCreate = FunctionEncoder.encode((Function)ContractDeployer.encodeCreate2(bytecodeBytes, calldataBytes, salt));
        Eip712Meta meta = new Eip712Meta(BigInteger.valueOf(160000L), null, factoryDeps, null);
        return new Transaction(from, "0x0000000000000000000000000000000000008006", gasPrice, gasLimit, null, calldataCreate, meta);
    }

    public static Transaction create2ContractTransaction(String from, BigInteger gasPrice, BigInteger gasLimit, String bytecode, String calldata, String customSignature) {
        byte[] bytecodeBytes = Numeric.hexStringToByteArray((String)bytecode);
        byte[] calldataBytes = Numeric.hexStringToByteArray((String)calldata);
        byte[] customSignatureBytes = Numeric.hexStringToByteArray((String)customSignature);
        String calldataCreate = FunctionEncoder.encode((Function)ContractDeployer.encodeCreate2(bytecodeBytes, calldataBytes));
        Eip712Meta meta = new Eip712Meta(BigInteger.valueOf(160000L), customSignatureBytes, new byte[][]{bytecodeBytes}, null);
        return new Transaction(from, "0x0000000000000000000000000000000000008006", gasPrice, gasLimit, null, calldataCreate, meta);
    }

    public static Transaction create2ContractTransaction(String from, BigInteger gasPrice, BigInteger gasLimit, String bytecode, String calldata, String customSignature, PaymasterParams paymasterParams) {
        byte[] bytecodeBytes = Numeric.hexStringToByteArray((String)bytecode);
        byte[] calldataBytes = Numeric.hexStringToByteArray((String)calldata);
        byte[] customSignatureBytes = Numeric.hexStringToByteArray((String)customSignature);
        String calldataCreate = FunctionEncoder.encode((Function)ContractDeployer.encodeCreate2(bytecodeBytes, calldataBytes));
        Eip712Meta meta = new Eip712Meta(BigInteger.valueOf(160000L), customSignatureBytes, new byte[][]{bytecodeBytes}, paymasterParams);
        return new Transaction(from, "0x0000000000000000000000000000000000008006", gasPrice, gasLimit, null, calldataCreate, meta);
    }

    public static Transaction create2AccountTransaction(String from, BigInteger gasPrice, BigInteger gasLimit, String bytecode) {
        byte[] bytecodeBytes = Numeric.hexStringToByteArray((String)bytecode);
        String calldata = FunctionEncoder.encode((Function)ContractDeployer.encodeCreate2Account(bytecodeBytes));
        Eip712Meta meta = new Eip712Meta(BigInteger.valueOf(160000L), null, new byte[][]{bytecodeBytes}, null);
        return new Transaction(from, "0x0000000000000000000000000000000000008006", gasPrice, gasLimit, null, calldata, meta);
    }

    public static Transaction create2AccountTransaction(String from, BigInteger gasPrice, BigInteger gasLimit, String bytecode, String calldata) {
        byte[] bytecodeBytes = Numeric.hexStringToByteArray((String)bytecode);
        byte[] calldataBytes = Numeric.hexStringToByteArray((String)calldata);
        String calldataCreate = FunctionEncoder.encode((Function)ContractDeployer.encodeCreate2Account(bytecodeBytes, calldataBytes));
        Eip712Meta meta = new Eip712Meta(BigInteger.valueOf(160000L), null, new byte[][]{bytecodeBytes}, null);
        return new Transaction(from, "0x0000000000000000000000000000000000008006", gasPrice, gasLimit, null, calldataCreate, meta);
    }

    public static Transaction create2AccountTransaction(String from, BigInteger gasPrice, BigInteger gasLimit, String bytecode, String calldata, byte[] salt) {
        byte[] bytecodeBytes = Numeric.hexStringToByteArray((String)bytecode);
        byte[] calldataBytes = Numeric.hexStringToByteArray((String)calldata);
        String calldataCreate = FunctionEncoder.encode((Function)ContractDeployer.encodeCreate2Account(bytecodeBytes, calldataBytes, salt));
        Eip712Meta meta = new Eip712Meta(BigInteger.valueOf(160000L), null, new byte[][]{bytecodeBytes}, null);
        return new Transaction(from, "0x0000000000000000000000000000000000008006", gasPrice, gasLimit, null, calldataCreate, meta);
    }

    public static Transaction createContractTransaction(String from, BigInteger gasPrice, BigInteger gasLimit, BigInteger value, String bytecode) {
        byte[] bytecodeBytes = Numeric.hexStringToByteArray((String)bytecode);
        String calldata = FunctionEncoder.encode((Function)ContractDeployer.encodeCreate(bytecodeBytes));
        Eip712Meta meta = new Eip712Meta(BigInteger.valueOf(160000L), null, new byte[][]{bytecodeBytes}, null);
        return new Transaction(from, "0x0000000000000000000000000000000000008006", gasPrice, gasLimit, value, calldata, meta);
    }

    public static Transaction createContractTransaction(String from, BigInteger gasPrice, BigInteger gasLimit, String bytecode) {
        byte[] bytecodeBytes = Numeric.hexStringToByteArray((String)bytecode);
        String calldata = FunctionEncoder.encode((Function)ContractDeployer.encodeCreate(bytecodeBytes));
        Eip712Meta meta = new Eip712Meta(BigInteger.valueOf(160000L), null, new byte[][]{bytecodeBytes}, null);
        return new Transaction(from, "0x0000000000000000000000000000000000008006", gasPrice, gasLimit, null, calldata, meta);
    }

    public static Transaction createContractTransaction(String from, BigInteger gasPrice, BigInteger gasLimit, String bytecode, String calldata) {
        byte[] bytecodeBytes = Numeric.hexStringToByteArray((String)bytecode);
        byte[] calldataBytes = Numeric.hexStringToByteArray((String)calldata);
        String calldataCreate = FunctionEncoder.encode((Function)ContractDeployer.encodeCreate(bytecodeBytes, calldataBytes));
        Eip712Meta meta = new Eip712Meta(BigInteger.valueOf(160000L), null, new byte[][]{bytecodeBytes}, null);
        return new Transaction(from, "0x0000000000000000000000000000000000008006", gasPrice, gasLimit, null, calldataCreate, meta);
    }

    public static Transaction createContractTransaction(String from, BigInteger gasPrice, BigInteger gasLimit, String bytecode, List<String> deps, String calldata) {
        byte[] bytecodeBytes = Numeric.hexStringToByteArray((String)bytecode);
        byte[] calldataBytes = Numeric.hexStringToByteArray((String)calldata);
        byte[][] factoryDeps = new byte[deps.size() + 1][];
        for (int i = 0; i < deps.size(); ++i) {
            factoryDeps[i] = Numeric.hexStringToByteArray((String)deps.get(i));
        }
        factoryDeps[deps.size()] = bytecodeBytes;
        String calldataCreate = FunctionEncoder.encode((Function)ContractDeployer.encodeCreate(bytecodeBytes, calldataBytes));
        Eip712Meta meta = new Eip712Meta(BigInteger.valueOf(160000L), null, factoryDeps, null);
        return new Transaction(from, "0x0000000000000000000000000000000000008006", gasPrice, gasLimit, null, calldataCreate, meta);
    }

    public static Transaction createFunctionCallTransaction(String from, String to, BigInteger gasPrice, BigInteger gasLimit, BigInteger value, String data) {
        Eip712Meta meta = new Eip712Meta(BigInteger.valueOf(160000L), null, null, null);
        return new Transaction(from, to, gasPrice, gasLimit, value, data, meta);
    }

    public static Transaction createFunctionCallTransaction(String from, String to, BigInteger gasPrice, BigInteger gasLimit, String data) {
        Eip712Meta meta = new Eip712Meta(BigInteger.valueOf(160000L), null, null, null);
        return new Transaction(from, to, gasPrice, gasLimit, null, data, meta);
    }

    public static Transaction createFunctionCallTransaction(String from, String to, BigInteger gasPrice, BigInteger gasLimit, BigInteger value, String data, String customSignature, PaymasterParams paymasterParams) {
        Eip712Meta meta = new Eip712Meta(BigInteger.valueOf(160000L), Numeric.hexStringToByteArray((String)customSignature), null, paymasterParams);
        return new Transaction(from, to, gasPrice, gasLimit, value, data, meta);
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public String getGas() {
        return Transaction.convert(this.gas);
    }

    public String getGasPrice() {
        return Transaction.convert(this.gasPrice);
    }

    public String getValue() {
        return Transaction.convert(this.value);
    }

    @JsonIgnore
    public BigInteger getGasNumber() {
        return this.gas;
    }

    @JsonIgnore
    public BigInteger getGasPriceNumber() {
        return this.gasPrice;
    }

    @JsonIgnore
    public BigInteger getValueNumber() {
        return this.value;
    }

    public String getData() {
        return this.data;
    }

    public String getTransactionType() {
        return Transaction.convert(BigInteger.valueOf(this.transactionType));
    }

    public AccessListObject getAccessList() {
        return this.accessList;
    }

    public Eip712Meta getEip712Meta() {
        return this.eip712Meta;
    }

    private static String convert(BigInteger value) {
        if (value != null) {
            return Numeric.encodeQuantity((BigInteger)value);
        }
        return null;
    }

    public Transaction(String from, String to, BigInteger gas, BigInteger gasPrice, BigInteger value, String data, Long transactionType, AccessListObject accessList, Eip712Meta eip712Meta) {
        this.from = from;
        this.to = to;
        this.gas = gas;
        this.gasPrice = gasPrice;
        this.value = value;
        this.data = data;
        this.transactionType = transactionType;
        this.accessList = accessList;
        this.eip712Meta = eip712Meta;
    }
}

