/*
 * Decompiled with CFR 0.152.
 */
package io.zksync.methods.response;

import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.utils.Numeric;

public class ZkTransactionReceipt
extends TransactionReceipt {
    private String l1BatchNumber;
    private String l1BatchTxIndex;

    public ZkTransactionReceipt() {
    }

    public ZkTransactionReceipt(String transactionHash, String transactionIndex, String blockHash, String blockNumber, String cumulativeGasUsed, String gasUsed, String contractAddress, String root, String status, String from, String to, List<Log> logs, String logsBloom, String revertReason, String type, String effectiveGasPrice, String l1BatchNumber, String l1BatchTxIndex) {
        super(transactionHash, transactionIndex, blockHash, blockNumber, cumulativeGasUsed, gasUsed, contractAddress, root, status, from, to, logs, logsBloom, revertReason, type, effectiveGasPrice);
        this.l1BatchNumber = l1BatchNumber;
        this.l1BatchTxIndex = l1BatchTxIndex;
    }

    public String getL1BatchNumberRaw() {
        return this.l1BatchNumber;
    }

    public BigInteger getL1BatchNumber() {
        return Numeric.decodeQuantity((String)this.l1BatchNumber);
    }

    public void setL1BatchNumber(String l1BatchNumber) {
        this.l1BatchNumber = l1BatchNumber;
    }

    public String getL1BatchTxIndexRaw() {
        return this.l1BatchTxIndex;
    }

    public BigInteger getL1BatchTxIndex() {
        return Numeric.decodeQuantity((String)this.l1BatchTxIndex);
    }

    public void setL1BatchTxIndex(String l1BatchTxIndex) {
        this.l1BatchTxIndex = l1BatchTxIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ZkTransactionReceipt)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ZkTransactionReceipt that = (ZkTransactionReceipt)((Object)o);
        return this.l1BatchNumber.equals(that.l1BatchNumber) && this.l1BatchTxIndex.equals(that.l1BatchTxIndex);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.l1BatchNumber, this.l1BatchTxIndex);
    }

    public String toString() {
        return "ZkTransactionReceipt{l1BatchNumber='" + this.l1BatchNumber + '\'' + ", l1BatchTxIndex='" + this.l1BatchTxIndex + '\'' + "} " + super.toString();
    }
}

