/*
 * Decompiled with CFR 0.152.
 */
package io.zksync.methods.response;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.zksync.methods.response.ZkTransaction;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.web3j.protocol.ObjectMapperFactory;
import org.web3j.protocol.core.Response;
import org.web3j.protocol.core.methods.response.AccessListObject;
import org.web3j.protocol.core.methods.response.EthBlock;
import org.web3j.utils.Numeric;

public class ZksBlock
extends Response<Block> {
    @JsonDeserialize(using=ResponseDeserialiser.class)
    public void setResult(Block result) {
        super.setResult((Object)result);
    }

    public Block getBlock() {
        return (Block)((Object)this.getResult());
    }

    public static class ResponseDeserialiser
    extends JsonDeserializer<Block> {
        private ObjectReader objectReader = ObjectMapperFactory.getObjectReader();

        public Block deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (jsonParser.getCurrentToken() != JsonToken.VALUE_NULL) {
                return (Block)((Object)this.objectReader.readValue(jsonParser, Block.class));
            }
            return null;
        }
    }

    public static class ResultTransactionDeserialiser
    extends JsonDeserializer<List<TransactionResult>> {
        private ObjectReader objectReader = ObjectMapperFactory.getObjectReader();

        public List<TransactionResult> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            ArrayList<TransactionResult> transactionResults;
            block3: {
                JsonToken nextToken;
                block2: {
                    transactionResults = new ArrayList<TransactionResult>();
                    nextToken = jsonParser.nextToken();
                    if (nextToken != JsonToken.START_OBJECT) break block2;
                    Iterator transactionObjectIterator = this.objectReader.readValues(jsonParser, TransactionObject.class);
                    while (transactionObjectIterator.hasNext()) {
                        transactionResults.add((TransactionResult)transactionObjectIterator.next());
                    }
                    break block3;
                }
                if (nextToken != JsonToken.VALUE_STRING) break block3;
                jsonParser.getValueAsString();
                Iterator transactionHashIterator = this.objectReader.readValues(jsonParser, TransactionHash.class);
                while (transactionHashIterator.hasNext()) {
                    transactionResults.add((TransactionResult)transactionHashIterator.next());
                }
            }
            return transactionResults;
        }
    }

    public static class TransactionObject
    extends ZkTransaction
    implements TransactionResult<ZkTransaction> {
        public TransactionObject(String hash, String nonce, String blockHash, String blockNumber, String chainId, String transactionIndex, String from, String to, String value, String gasPrice, String gas, String input, String creates, String publicKey, String raw, String r, String s, long v, String type, String maxFeePerGas, String maxPriorityFeePerGas, List<AccessListObject> accessList, String l1BatchNumber, String l1BatchTxIndex) {
            super(hash, nonce, blockHash, blockNumber, chainId, transactionIndex, from, to, value, gas, gasPrice, input, creates, publicKey, raw, r, s, v, type, maxFeePerGas, maxPriorityFeePerGas, accessList, l1BatchNumber, l1BatchTxIndex);
        }

        @Override
        public ZkTransaction get() {
            return this;
        }
    }

    public static class TransactionHash
    implements TransactionResult<String> {
        private String value;

        public TransactionHash() {
        }

        public TransactionHash(String value) {
            this.value = value;
        }

        @Override
        public String get() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TransactionHash)) {
                return false;
            }
            TransactionHash that = (TransactionHash)o;
            return Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }
    }

    public static interface TransactionResult<T> {
        public T get();
    }

    public static class Block
    extends EthBlock.Block {
        private String l1BatchNumber;
        private String l1BatchTimestamp;

        public Block() {
        }

        public Block(String number, String hash, String parentHash, String nonce, String sha3Uncles, String logsBloom, String transactionsRoot, String stateRoot, String receiptsRoot, String author, String miner, String mixHash, String difficulty, String totalDifficulty, String extraData, String size, String gasLimit, String gasUsed, String timestamp, List<EthBlock.TransactionResult> transactions, List<String> uncles, List<String> sealFields, String baseFeePerGas, String l1BatchNumber, String l1BatchTimestamp) {
            super(number, hash, parentHash, nonce, sha3Uncles, logsBloom, transactionsRoot, stateRoot, receiptsRoot, author, miner, mixHash, difficulty, totalDifficulty, extraData, size, gasLimit, gasUsed, timestamp, transactions, uncles, sealFields, baseFeePerGas);
            this.l1BatchNumber = l1BatchNumber;
            this.l1BatchTimestamp = l1BatchTimestamp;
        }

        public BigInteger getL1BatchNumber() {
            return Numeric.decodeQuantity((String)this.l1BatchNumber);
        }

        public void setL1BatchNumber(String l1BatchNumber) {
            this.l1BatchNumber = l1BatchNumber;
        }

        public BigInteger getL1BatchTimestamp() {
            return Numeric.decodeQuantity((String)this.l1BatchTimestamp);
        }

        public void setL1BatchTimestamp(String l1BatchTimestamp) {
            this.l1BatchTimestamp = l1BatchTimestamp;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Block)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Block block = (Block)((Object)o);
            if (this.getL1BatchNumber() != null ? !this.getL1BatchNumber().equals(block.getL1BatchNumber()) : block.getL1BatchNumber() != null) {
                return false;
            }
            return this.getL1BatchTimestamp() != null ? this.getL1BatchTimestamp().equals(block.getL1BatchTimestamp()) : block.getL1BatchTimestamp() == null;
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.getL1BatchTimestamp() != null ? this.getL1BatchTimestamp().hashCode() : 0);
            result = 31 * result + (this.getL1BatchNumber() != null ? this.getL1BatchNumber().hashCode() : 0);
            return result;
        }
    }
}

