/*
 * Decompiled with CFR 0.152.
 */
package io.zksync.protocol;

import io.zksync.methods.request.Transaction;
import io.zksync.methods.response.ZksAccountBalances;
import io.zksync.methods.response.ZksBlock;
import io.zksync.methods.response.ZksBridgeAddresses;
import io.zksync.methods.response.ZksContractDebugInfo;
import io.zksync.methods.response.ZksEstimateFee;
import io.zksync.methods.response.ZksGetLogs;
import io.zksync.methods.response.ZksGetTransactionByHash;
import io.zksync.methods.response.ZksGetTransactionDetails;
import io.zksync.methods.response.ZksGetTransactionReceipt;
import io.zksync.methods.response.ZksL1ChainId;
import io.zksync.methods.response.ZksMainContract;
import io.zksync.methods.response.ZksMessageProof;
import io.zksync.methods.response.ZksTestnetPaymasterAddress;
import io.zksync.methods.response.ZksTokenPrice;
import io.zksync.methods.response.ZksTokens;
import io.zksync.methods.response.ZksTransactionTrace;
import io.zksync.protocol.ZkSync;
import java.util.Arrays;
import java.util.Collections;
import org.jetbrains.annotations.Nullable;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.JsonRpc2_0Web3j;
import org.web3j.protocol.core.Request;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.EthEstimateGas;

public class JsonRpc2_0ZkSync
extends JsonRpc2_0Web3j
implements ZkSync {
    public static final int DEFAULT_BLOCK_COMMIT_TIME = 800;

    public JsonRpc2_0ZkSync(Web3jService web3jService) {
        super(web3jService);
    }

    @Override
    public Request<?, ZksEstimateFee> zksEstimateFee(Transaction transaction) {
        return new Request("zks_estimateFee", Collections.singletonList(transaction), this.web3jService, ZksEstimateFee.class);
    }

    @Override
    public Request<?, ZksMainContract> zksMainContract() {
        return new Request("zks_getMainContract", Collections.emptyList(), this.web3jService, ZksMainContract.class);
    }

    @Override
    public Request<?, ZksTokens> zksGetConfirmedTokens(Integer from, Short limit) {
        return new Request("zks_getConfirmedTokens", Arrays.asList(from, limit), this.web3jService, ZksTokens.class);
    }

    @Override
    public Request<?, ZksTokenPrice> zksGetTokenPrice(String tokenAddress) {
        return new Request("zks_getTokenPrice", Collections.singletonList(tokenAddress), this.web3jService, ZksTokenPrice.class);
    }

    @Override
    public Request<?, ZksL1ChainId> zksL1ChainId() {
        return new Request("zks_L1ChainId", Collections.emptyList(), this.web3jService, ZksL1ChainId.class);
    }

    @Override
    public Request<?, ZksContractDebugInfo> zksGetContractDebugInfo(String contractAddress) {
        return new Request("zks_getContractDebugInfo", Collections.singletonList(contractAddress), this.web3jService, ZksContractDebugInfo.class);
    }

    @Override
    public Request<?, ZksTransactionTrace> zksGetTransactionTrace(String transactionHash) {
        return new Request("zks_getTransactionTrace", Collections.singletonList(transactionHash), this.web3jService, ZksTransactionTrace.class);
    }

    @Override
    public Request<?, ZksAccountBalances> zksGetAllAccountBalances(String address) {
        return new Request("zks_getAllAccountBalances", Collections.singletonList(address), this.web3jService, ZksAccountBalances.class);
    }

    @Override
    public Request<?, ZksBridgeAddresses> zksGetBridgeContracts() {
        return new Request("zks_getBridgeContracts", Collections.emptyList(), this.web3jService, ZksBridgeAddresses.class);
    }

    @Override
    public Request<?, ZksMessageProof> zksGetL2ToL1MsgProof(Integer block, String sender, String message, @Nullable Long l2LogPosition) {
        return new Request("zks_getL2ToL1MsgProof", Arrays.asList(block, sender, message), this.web3jService, ZksMessageProof.class);
    }

    @Override
    public Request<?, EthEstimateGas> ethEstimateGas(Transaction transaction) {
        return new Request("eth_estimateGas", Collections.singletonList(transaction), this.web3jService, EthEstimateGas.class);
    }

    @Override
    public Request<?, ZksTestnetPaymasterAddress> zksGetTestnetPaymaster() {
        return new Request("zks_getTestnetPaymaster", Collections.emptyList(), this.web3jService, ZksTestnetPaymasterAddress.class);
    }

    @Override
    public Request<?, ZksGetTransactionReceipt> zksGetTransactionReceipt(String transactionHash) {
        return new Request("eth_getTransactionReceipt", Collections.singletonList(transactionHash), this.web3jService, ZksGetTransactionReceipt.class);
    }

    @Override
    public Request<?, ZksGetTransactionDetails> zksGetTransactionDetails(String transactionHash) {
        return new Request("zks_getTransactionDetails", Collections.singletonList(transactionHash), this.web3jService, ZksGetTransactionDetails.class);
    }

    @Override
    public Request<?, ZksGetTransactionByHash> zksGetTransactionByHash(String transactionHash) {
        return new Request("eth_getTransactionByHash", Collections.singletonList(transactionHash), this.web3jService, ZksGetTransactionByHash.class);
    }

    @Override
    public Request<?, ZksGetLogs> zksGetLogs(EthFilter ethFilter) {
        return new Request("eth_getLogs", Collections.singletonList(ethFilter), this.web3jService, ZksGetLogs.class);
    }

    @Override
    public Request<?, ZksBlock> zksGetBlockByHash(String blockHash, boolean returnFullTransactionObjects) {
        return new Request("eth_getBlockByHash", Arrays.asList(blockHash, returnFullTransactionObjects), this.web3jService, ZksBlock.class);
    }

    @Override
    public Request<?, ZksBlock> zksGetBlockByNumber(DefaultBlockParameter defaultBlockParameter, boolean returnFullTransactionObjects) {
        return new Request("eth_getBlockByNumber", Arrays.asList(defaultBlockParameter.getValue(), returnFullTransactionObjects), this.web3jService, ZksBlock.class);
    }
}

