/*
 * Decompiled with CFR 0.152.
 */
package io.zksync.protocol.core;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.zksync.protocol.core.TokenId;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Token
implements TokenId {
    public static final Token ETH = Token.createETH();
    private String l1Address;
    private String l2Address;
    private String symbol;
    private Integer decimals;

    public String formatToken(BigInteger amount) {
        return new BigDecimal(amount).divide(BigDecimal.TEN.pow(this.decimals)).toString();
    }

    public boolean isETH() {
        return this.l2Address.equals("0x0000000000000000000000000000000000000000") && this.symbol.equals("ETH");
    }

    @Override
    public BigDecimal intoDecimal(BigInteger amount) {
        return new BigDecimal(amount).setScale(this.decimals).divide(BigDecimal.TEN.pow(this.decimals), RoundingMode.DOWN);
    }

    public BigInteger toBigInteger(BigDecimal amount) {
        return amount.multiply(BigDecimal.TEN.pow(this.decimals)).toBigInteger();
    }

    public BigInteger toBigInteger(double amount) {
        return BigDecimal.valueOf(amount).multiply(BigDecimal.TEN.pow(this.decimals)).toBigInteger();
    }

    public static Token createETH() {
        return new Token("0x0000000000000000000000000000000000000000", "0x0000000000000000000000000000000000000000", "ETH", 18);
    }

    public String getL1Address() {
        return this.l1Address;
    }

    public String getL2Address() {
        return this.l2Address;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    public Integer getDecimals() {
        return this.decimals;
    }

    public void setL1Address(String l1Address) {
        this.l1Address = l1Address;
    }

    public void setL2Address(String l2Address) {
        this.l2Address = l2Address;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public void setDecimals(Integer decimals) {
        this.decimals = decimals;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Token)) {
            return false;
        }
        Token other = (Token)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$decimals = this.getDecimals();
        Integer other$decimals = other.getDecimals();
        if (this$decimals == null ? other$decimals != null : !((Object)this$decimals).equals(other$decimals)) {
            return false;
        }
        String this$l1Address = this.getL1Address();
        String other$l1Address = other.getL1Address();
        if (this$l1Address == null ? other$l1Address != null : !this$l1Address.equals(other$l1Address)) {
            return false;
        }
        String this$l2Address = this.getL2Address();
        String other$l2Address = other.getL2Address();
        if (this$l2Address == null ? other$l2Address != null : !this$l2Address.equals(other$l2Address)) {
            return false;
        }
        String this$symbol = this.getSymbol();
        String other$symbol = other.getSymbol();
        return !(this$symbol == null ? other$symbol != null : !this$symbol.equals(other$symbol));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Token;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $decimals = this.getDecimals();
        result = result * 59 + ($decimals == null ? 43 : ((Object)$decimals).hashCode());
        String $l1Address = this.getL1Address();
        result = result * 59 + ($l1Address == null ? 43 : $l1Address.hashCode());
        String $l2Address = this.getL2Address();
        result = result * 59 + ($l2Address == null ? 43 : $l2Address.hashCode());
        String $symbol = this.getSymbol();
        result = result * 59 + ($symbol == null ? 43 : $symbol.hashCode());
        return result;
    }

    public String toString() {
        return "Token(l1Address=" + this.getL1Address() + ", l2Address=" + this.getL2Address() + ", symbol=" + this.getSymbol() + ", decimals=" + this.getDecimals() + ")";
    }

    public Token() {
    }

    public Token(String l1Address, String l2Address, String symbol, Integer decimals) {
        this.l1Address = l1Address;
        this.l2Address = l2Address;
        this.symbol = symbol;
        this.decimals = decimals;
    }
}

