/*
 * Decompiled with CFR 0.152.
 */
package io.zksync.protocol.provider;

import io.zksync.methods.response.ZksBridgeAddresses;
import io.zksync.methods.response.ZksMainContract;
import io.zksync.protocol.ZkSync;
import io.zksync.protocol.core.BridgeAddresses;
import io.zksync.protocol.core.Token;
import io.zksync.protocol.provider.DefaultEthereumProvider;
import io.zksync.wrappers.IL1Bridge;
import io.zksync.wrappers.ZkSyncContract;
import java.math.BigInteger;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.Nullable;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;

public interface EthereumProvider {
    public CompletableFuture<TransactionReceipt> approveDeposits(Token var1, Optional<BigInteger> var2);

    public CompletableFuture<TransactionReceipt> transfer(Token var1, BigInteger var2, String var3);

    public CompletableFuture<BigInteger> getBaseCost(BigInteger var1, BigInteger var2, @Nullable BigInteger var3);

    public CompletableFuture<TransactionReceipt> requestExecute(String var1, BigInteger var2, byte[] var3, BigInteger var4, @Nullable byte[][] var5, @Nullable BigInteger var6, @Nullable BigInteger var7, String var8);

    public CompletableFuture<TransactionReceipt> deposit(Token var1, BigInteger var2, BigInteger var3, String var4);

    public CompletableFuture<TransactionReceipt> withdraw(Token var1, BigInteger var2, String var3);

    public CompletableFuture<Boolean> isDepositApproved(Token var1, String var2, Optional<BigInteger> var3);

    public String l1ERC20BridgeAddress();

    public static CompletableFuture<EthereumProvider> load(ZkSync zksync, Web3j ethereum, TransactionManager transactionManager, ContractGasProvider gasProvider) {
        return CompletableFuture.supplyAsync(() -> {
            BridgeAddresses bridgeAddresses = (BridgeAddresses)((ZksBridgeAddresses)((Object)((Object)zksync.zksGetBridgeContracts().sendAsync().join()))).getResult();
            String mainContract = (String)((ZksMainContract)((Object)((Object)zksync.zksMainContract().sendAsync().join()))).getResult();
            IL1Bridge erc20Bridge = IL1Bridge.load(bridgeAddresses.getL1Erc20DefaultBridge(), ethereum, transactionManager, gasProvider);
            ZkSyncContract zkSyncContract = ZkSyncContract.load(mainContract, ethereum, transactionManager, gasProvider);
            return new DefaultEthereumProvider(ethereum, transactionManager, gasProvider, zkSyncContract, erc20Bridge);
        });
    }
}

