/*
 * Decompiled with CFR 0.152.
 */
package io.zksync.transaction.fee;

import io.zksync.methods.request.Transaction;
import io.zksync.methods.response.ZksEstimateFee;
import io.zksync.protocol.ZkSync;
import io.zksync.protocol.core.Token;
import io.zksync.protocol.exceptions.JsonRpcResponseException;
import io.zksync.transaction.fee.Fee;
import io.zksync.transaction.fee.ZkTransactionFeeProvider;
import java.math.BigInteger;
import org.web3j.protocol.core.methods.response.EthEstimateGas;
import org.web3j.protocol.core.methods.response.EthGasPrice;

public class DefaultTransactionFeeProvider
implements ZkTransactionFeeProvider {
    private ZkSync zksync;
    private Token feeToken;

    @Override
    public Fee getFee(Transaction transaction) {
        ZksEstimateFee estimateFee = (ZksEstimateFee)this.zksync.zksEstimateFee(transaction).send();
        if (estimateFee.hasError()) {
            throw new JsonRpcResponseException(estimateFee);
        }
        return (Fee)estimateFee.getResult();
    }

    @Override
    public Token getFeeToken() {
        return this.feeToken;
    }

    public BigInteger getGasPrice(String contractFunc) {
        return ((EthGasPrice)this.zksync.ethGasPrice().sendAsync().join()).getGasPrice();
    }

    public BigInteger getGasPrice() {
        return ((EthGasPrice)this.zksync.ethGasPrice().sendAsync().join()).getGasPrice();
    }

    public BigInteger getGasLimit(String contractFunc) {
        return null;
    }

    public BigInteger getGasLimit() {
        return null;
    }

    @Override
    public BigInteger getGasLimit(Transaction transaction) {
        return ((EthEstimateGas)this.zksync.ethEstimateGas(transaction).sendAsync().join()).getAmountUsed();
    }

    public DefaultTransactionFeeProvider(ZkSync zksync, Token feeToken) {
        this.zksync = zksync;
        this.feeToken = feeToken;
    }
}

