/*
 * Decompiled with CFR 0.152.
 */
package io.zksync.transaction.fee;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.math.BigInteger;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.utils.Numeric;

public class Fee {
    @JsonIgnore
    private Uint256 gasLimit;
    @JsonIgnore
    private Uint256 maxFeePerGas;
    @JsonIgnore
    private Uint256 maxPriorityFeePerGas;
    @JsonIgnore
    private Uint256 gasPerPubdataLimit;

    public Fee() {
        this.gasLimit = Uint256.DEFAULT;
        this.maxFeePerGas = Uint256.DEFAULT;
        this.maxPriorityFeePerGas = Uint256.DEFAULT;
        this.gasPerPubdataLimit = Uint256.DEFAULT;
    }

    public Fee(BigInteger gqsLimit, BigInteger maxFeePerGas, BigInteger maxPriorityFeePerGas, BigInteger gasPerPubdataLimit) {
        this.gasLimit = new Uint256(gqsLimit);
        this.maxFeePerGas = new Uint256(maxFeePerGas);
        this.maxPriorityFeePerGas = new Uint256(maxPriorityFeePerGas);
        this.gasPerPubdataLimit = new Uint256(gasPerPubdataLimit);
    }

    public BigInteger getGasLimitNumber() {
        return this.gasLimit.getValue();
    }

    public void setGasLimit(BigInteger gasLimit) {
        this.gasLimit = new Uint256(gasLimit);
    }

    @JsonSetter(value="gas_limit")
    public void setGasLimit(String gasLimit) {
        this.gasLimit = new Uint256(Numeric.toBigInt((String)gasLimit));
    }

    public BigInteger getGasPriceLimitNumber() {
        return this.maxFeePerGas.getValue();
    }

    public void setMaxFeePerGas(BigInteger maxFeePerGas) {
        this.maxFeePerGas = new Uint256(maxFeePerGas);
    }

    @JsonSetter(value="max_fee_per_gas")
    public void setMaxFeePerGas(String gasPriceLimit) {
        this.maxFeePerGas = new Uint256(Numeric.toBigInt((String)gasPriceLimit));
    }

    public BigInteger getMaxPriorityFeePerErgNumber() {
        return this.maxPriorityFeePerGas.getValue();
    }

    public void setMaxPriorityFeePerGas(BigInteger maxPriorityFeePerGas) {
        this.maxPriorityFeePerGas = new Uint256(maxPriorityFeePerGas);
    }

    @JsonSetter(value="max_priority_fee_per_erg")
    public void setMaxPriorityFeePerGas(String maxPriorityFeePerErg) {
        this.maxPriorityFeePerGas = new Uint256(Numeric.toBigInt((String)maxPriorityFeePerErg));
    }

    public BigInteger getGasPerPubdataLimitNumber() {
        return this.gasPerPubdataLimit.getValue();
    }

    public void setGasPerPubdataLimit(BigInteger gasPerPubdataLimit) {
        this.gasPerPubdataLimit = new Uint256(gasPerPubdataLimit);
    }

    @JsonSetter(value="gas_per_pubdata_limit")
    public void setGasPerPubdataLimit(String gasPerPubdataLimit) {
        this.gasPerPubdataLimit = new Uint256(Numeric.toBigInt((String)gasPerPubdataLimit));
    }

    public Uint256 getGasLimit() {
        return this.gasLimit;
    }

    public Uint256 getMaxFeePerGas() {
        return this.maxFeePerGas;
    }

    public Uint256 getMaxPriorityFeePerGas() {
        return this.maxPriorityFeePerGas;
    }

    public Uint256 getGasPerPubdataLimit() {
        return this.gasPerPubdataLimit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Fee)) {
            return false;
        }
        Fee other = (Fee)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Uint256 this$gasLimit = this.getGasLimit();
        Uint256 other$gasLimit = other.getGasLimit();
        if (this$gasLimit == null ? other$gasLimit != null : !this$gasLimit.equals(other$gasLimit)) {
            return false;
        }
        Uint256 this$maxFeePerGas = this.getMaxFeePerGas();
        Uint256 other$maxFeePerGas = other.getMaxFeePerGas();
        if (this$maxFeePerGas == null ? other$maxFeePerGas != null : !this$maxFeePerGas.equals(other$maxFeePerGas)) {
            return false;
        }
        Uint256 this$maxPriorityFeePerGas = this.getMaxPriorityFeePerGas();
        Uint256 other$maxPriorityFeePerGas = other.getMaxPriorityFeePerGas();
        if (this$maxPriorityFeePerGas == null ? other$maxPriorityFeePerGas != null : !this$maxPriorityFeePerGas.equals(other$maxPriorityFeePerGas)) {
            return false;
        }
        Uint256 this$gasPerPubdataLimit = this.getGasPerPubdataLimit();
        Uint256 other$gasPerPubdataLimit = other.getGasPerPubdataLimit();
        return !(this$gasPerPubdataLimit == null ? other$gasPerPubdataLimit != null : !this$gasPerPubdataLimit.equals(other$gasPerPubdataLimit));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Fee;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Uint256 $gasLimit = this.getGasLimit();
        result = result * 59 + ($gasLimit == null ? 43 : $gasLimit.hashCode());
        Uint256 $maxFeePerGas = this.getMaxFeePerGas();
        result = result * 59 + ($maxFeePerGas == null ? 43 : $maxFeePerGas.hashCode());
        Uint256 $maxPriorityFeePerGas = this.getMaxPriorityFeePerGas();
        result = result * 59 + ($maxPriorityFeePerGas == null ? 43 : $maxPriorityFeePerGas.hashCode());
        Uint256 $gasPerPubdataLimit = this.getGasPerPubdataLimit();
        result = result * 59 + ($gasPerPubdataLimit == null ? 43 : $gasPerPubdataLimit.hashCode());
        return result;
    }

    public String toString() {
        return "Fee(gasLimit=" + this.getGasLimit() + ", maxFeePerGas=" + this.getMaxFeePerGas() + ", maxPriorityFeePerGas=" + this.getMaxPriorityFeePerGas() + ", gasPerPubdataLimit=" + this.getGasPerPubdataLimit() + ")";
    }

    public Fee(Uint256 gasLimit, Uint256 maxFeePerGas, Uint256 maxPriorityFeePerGas, Uint256 gasPerPubdataLimit) {
        this.gasLimit = gasLimit;
        this.maxFeePerGas = maxFeePerGas;
        this.maxPriorityFeePerGas = maxPriorityFeePerGas;
        this.gasPerPubdataLimit = gasPerPubdataLimit;
    }
}

