/*
 * Decompiled with CFR 0.152.
 */
package io.zksync.transaction.manager;

import io.zksync.abi.TransactionEncoder;
import io.zksync.crypto.eip712.Eip712Domain;
import io.zksync.crypto.signer.EthSigner;
import io.zksync.methods.request.Eip712Meta;
import io.zksync.protocol.ZkSync;
import io.zksync.protocol.core.ZkBlockParameterName;
import io.zksync.protocol.exceptions.JsonRpcResponseException;
import io.zksync.transaction.fee.ZkTransactionFeeProvider;
import io.zksync.transaction.response.ZkSyncTransactionReceiptProcessor;
import io.zksync.transaction.type.Transaction712;
import java.io.IOException;
import java.math.BigInteger;
import java.util.concurrent.CompletableFuture;
import org.web3j.crypto.transaction.type.ITransaction;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.Response;
import org.web3j.protocol.core.methods.request.Transaction;
import org.web3j.protocol.core.methods.response.EthCall;
import org.web3j.protocol.core.methods.response.EthGetCode;
import org.web3j.protocol.core.methods.response.EthGetTransactionCount;
import org.web3j.protocol.core.methods.response.EthSendTransaction;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.response.TransactionReceiptProcessor;
import org.web3j.utils.Numeric;

public class ZkSyncTransactionManager
extends TransactionManager {
    public static final int DEFAULT_POLLING_ATTEMPTS_PER_TX_HASH = 40;
    public static final long DEFAULT_POLLING_FREQUENCY = 800L;
    private final ZkSync zkSync;
    private final EthSigner signer;
    private final ZkTransactionFeeProvider feeProvider;

    public ZkSyncTransactionManager(ZkSync zkSync, EthSigner signer, ZkTransactionFeeProvider feeProvider) {
        super((TransactionReceiptProcessor)new ZkSyncTransactionReceiptProcessor(zkSync, 800L, 40), signer.getAddress());
        this.zkSync = zkSync;
        this.signer = signer;
        this.feeProvider = feeProvider;
    }

    public EthSendTransaction sendTransaction(BigInteger gasPrice, BigInteger gasLimit, String to, String data, BigInteger value, boolean constructor) throws IOException {
        String signature;
        Transaction712 transaction;
        byte[] signed;
        EthSendTransaction response;
        long chainId = this.getSigner().getDomain().join().getChainId().getValue().longValue();
        if (gasPrice == null) {
            gasPrice = this.getFeeProvider().getGasPrice();
        }
        Eip712Meta meta = new Eip712Meta(BigInteger.valueOf(160000L), null, null, null);
        if (constructor) {
            throw new UnsupportedOperationException("Not supported deploying with Contract wrapper");
        }
        if (gasLimit == null) {
            io.zksync.methods.request.Transaction estimate = io.zksync.methods.request.Transaction.createFunctionCallTransaction(this.getFromAddress(), to, BigInteger.ZERO, BigInteger.ZERO, data);
            gasLimit = this.getFeeProvider().getGasLimit(estimate);
        }
        if ((response = (EthSendTransaction)this.zkSync.ethSendRawTransaction(Numeric.toHexString((byte[])(signed = TransactionEncoder.encode((ITransaction)(transaction = new Transaction712(chainId, this.getNonce(), gasLimit, to, value, data, BigInteger.valueOf(100000000L), gasPrice, this.getFromAddress(), meta)), TransactionEncoder.getSignatureData(signature = (String)((CompletableFuture)this.getSigner().getDomain().thenCompose(domain -> this.getSigner().signTypedData((Eip712Domain)domain, transaction))).join()))))).send()).hasError()) {
            throw new JsonRpcResponseException((Response<?>)response);
        }
        return response;
    }

    public EthSendTransaction sendEIP1559Transaction(long chainId, BigInteger maxPriorityFeePerGas, BigInteger maxFeePerGas, BigInteger gasLimit, String to, String data, BigInteger value, boolean constructor) throws IOException {
        return this.sendTransaction(maxPriorityFeePerGas, gasLimit, to, data, value, constructor);
    }

    public String sendCall(String to, String data, DefaultBlockParameter defaultBlockParameter) throws IOException {
        EthCall ethCall = (EthCall)this.zkSync.ethCall(Transaction.createEthCallTransaction((String)this.getFromAddress(), (String)to, (String)data), defaultBlockParameter).send();
        if (ethCall.hasError()) {
            throw new JsonRpcResponseException((Response<?>)ethCall);
        }
        return ethCall.getValue();
    }

    public EthGetCode getCode(String contractAddress, DefaultBlockParameter defaultBlockParameter) throws IOException {
        return (EthGetCode)this.zkSync.ethGetCode(contractAddress, defaultBlockParameter).send();
    }

    public ZkTransactionFeeProvider getFeeProvider() {
        return this.feeProvider;
    }

    public EthSigner getSigner() {
        return this.signer;
    }

    protected BigInteger getNonce() throws IOException {
        EthGetTransactionCount ethGetTransactionCount = (EthGetTransactionCount)this.zkSync.ethGetTransactionCount(this.getSigner().getAddress(), ZkBlockParameterName.COMMITTED).send();
        return ethGetTransactionCount.getTransactionCount();
    }

    private boolean isVanillaEVMByteCode(String bytecodeHex) {
        return bytecodeHex.startsWith("0x60");
    }
}

