/*
 * Decompiled with CFR 0.152.
 */
package io.zksync.transaction.response;

import io.zksync.protocol.ZkSync;
import java.io.IOException;
import java.util.Optional;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.methods.response.EthGetTransactionReceipt;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.protocol.exceptions.TransactionException;
import org.web3j.tx.response.TransactionReceiptProcessor;

public class ZkSyncTransactionReceiptProcessor
extends TransactionReceiptProcessor {
    private final ZkSync zkSync;
    protected final long sleepDuration;
    protected final int attempts;

    public ZkSyncTransactionReceiptProcessor(ZkSync zkSync, long sleepDuration, int attempts) {
        super((Web3j)zkSync);
        this.zkSync = zkSync;
        this.attempts = attempts;
        this.sleepDuration = sleepDuration;
    }

    public TransactionReceipt waitForTransactionReceipt(String transactionHash) throws IOException, TransactionException {
        return this.getTransactionReceipt(transactionHash, this.sleepDuration, this.attempts);
    }

    private TransactionReceipt getTransactionReceipt(String transactionHash, long sleepDuration, int attempts) throws IOException, TransactionException {
        Optional<? extends TransactionReceipt> receiptOptional = this.sendTransactionReceiptRequest(transactionHash);
        for (int i = 0; i < attempts; ++i) {
            if (!receiptOptional.isPresent() || receiptOptional.get().getBlockHash() == null) {
                try {
                    Thread.sleep(sleepDuration);
                }
                catch (InterruptedException e) {
                    throw new TransactionException((Throwable)e);
                }
            } else {
                return receiptOptional.get();
            }
            receiptOptional = this.sendTransactionReceiptRequest(transactionHash);
        }
        throw new TransactionException("Transaction receipt was not generated after " + sleepDuration * (long)attempts / 1000L + " seconds for transaction: " + transactionHash, transactionHash);
    }

    Optional<? extends TransactionReceipt> sendTransactionReceiptRequest(String transactionHash) throws IOException, TransactionException {
        EthGetTransactionReceipt transactionReceipt = (EthGetTransactionReceipt)this.zkSync.ethGetTransactionReceipt(transactionHash).send();
        if (transactionReceipt.hasError()) {
            throw new TransactionException("Error processing request: " + transactionReceipt.getError().getMessage());
        }
        return transactionReceipt.getTransactionReceipt();
    }
}

