/*
 * Decompiled with CFR 0.152.
 */
package io.zksync.transaction.type;

import io.zksync.crypto.eip712.Structurable;
import io.zksync.methods.request.Eip712Meta;
import io.zksync.utils.ContractDeployer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.web3j.abi.datatypes.DynamicArray;
import org.web3j.abi.datatypes.DynamicBytes;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.generated.Bytes32;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.crypto.Sign;
import org.web3j.crypto.transaction.type.Transaction1559;
import org.web3j.crypto.transaction.type.TransactionType;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.utils.Assertions;
import org.web3j.utils.Numeric;

public class Transaction712
extends Transaction1559
implements Structurable {
    static final String TRANSACTION_TYPE = "Transaction";
    public static final byte EIP_712_TX_TYPE = 113;
    private final String from;
    private final Eip712Meta meta;

    public Transaction712(long chainId, BigInteger nonce, BigInteger gasLimit, String to, BigInteger value, String data, BigInteger maxPriorityFeePerGas, BigInteger maxFeePerGas, String from, Eip712Meta meta) {
        super(chainId, nonce, gasLimit, to, value, data, maxPriorityFeePerGas, maxFeePerGas);
        this.from = from;
        this.meta = meta;
    }

    public List<RlpType> asRlpValues(Sign.SignatureData signatureData) {
        Assertions.verifyPrecondition((signatureData != null || this.getMeta().getCustomSignature() != null ? 1 : 0) != 0, (String)"One of `signatureData` and `meta.customSignature` MUST be set");
        ArrayList<RlpType> result = new ArrayList<RlpType>();
        result.add((RlpType)RlpString.create((BigInteger)this.getNonce()));
        result.add((RlpType)RlpString.create((BigInteger)this.getMaxPriorityFeePerGas()));
        result.add((RlpType)RlpString.create((BigInteger)this.getMaxFeePerGas()));
        result.add((RlpType)RlpString.create((BigInteger)this.getGasLimit()));
        String to = this.getTo();
        if (to != null && to.length() > 0) {
            result.add((RlpType)RlpString.create((byte[])Numeric.hexStringToByteArray((String)to)));
        } else {
            result.add((RlpType)RlpString.create((String)""));
        }
        result.add((RlpType)RlpString.create((BigInteger)this.getValue()));
        byte[] data = Numeric.hexStringToByteArray((String)this.getData());
        result.add((RlpType)RlpString.create((byte[])data));
        result.add((RlpType)RlpString.create((long)this.getChainId()));
        result.add((RlpType)RlpString.create((String)""));
        result.add((RlpType)RlpString.create((String)""));
        result.add((RlpType)RlpString.create((long)this.getChainId()));
        result.add((RlpType)RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getFrom())));
        BigInteger gasPerPubdata = this.getGasPerPubdata();
        result.add((RlpType)RlpString.create((BigInteger)gasPerPubdata));
        List factoryDeps = this.getFactoryDeps() != null ? Arrays.stream(this.getFactoryDeps()).map(RlpString::create).collect(Collectors.toList()) : Collections.emptyList();
        result.add((RlpType)new RlpList(factoryDeps));
        if (this.getMeta().getCustomSignature() != null) {
            result.add((RlpType)RlpString.create((byte[])this.getMeta().getCustomSignature()));
        } else {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            try {
                output.write(signatureData.getR());
                output.write(signatureData.getS());
                output.write(signatureData.getV());
            }
            catch (IOException e) {
                throw new IllegalStateException("Error when creating ETH signature", e);
            }
            result.add((RlpType)RlpString.create((byte[])output.toByteArray()));
        }
        List<Object> paymasterParams = this.getMeta().getPaymasterParams() != null && this.getPaymaster() != null && this.getPaymasterInput() != null ? Arrays.asList(RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getMeta().getPaymasterParams().getPaymaster())), RlpString.create((byte[])this.getMeta().getPaymasterParams().getPaymasterInput())) : Collections.emptyList();
        result.add((RlpType)new RlpList(paymasterParams));
        return result;
    }

    public String getFrom() {
        return this.from;
    }

    public BigInteger getGasPerPubdata() {
        return this.meta.getGasPerPubdataNumber();
    }

    public byte[][] getFactoryDeps() {
        return this.meta.getFactoryDeps();
    }

    public Eip712Meta getMeta() {
        return this.meta;
    }

    public String getPaymaster() {
        return this.getMeta() != null && this.getMeta().getPaymasterParams() != null ? this.getMeta().getPaymasterParams().getPaymaster() : null;
    }

    public byte[] getPaymasterInput() {
        return this.getMeta() != null && this.getMeta().getPaymasterParams() != null ? this.getMeta().getPaymasterParams().getPaymasterInput() : null;
    }

    public TransactionType getType() {
        return TransactionType.LEGACY;
    }

    @Override
    public String getTypeName() {
        return TRANSACTION_TYPE;
    }

    @Override
    public List<Pair<String, Type<?>>> eip712types() {
        ArrayList result = new ArrayList(13);
        result.add(Pair.of((Object)"txType", (Object)new Uint256(113L)));
        result.add(Pair.of((Object)"from", (Object)new Uint256(Numeric.toBigInt((String)this.getFrom()))));
        result.add(Pair.of((Object)"to", (Object)(this.getTo() != null ? new Uint256(Numeric.toBigInt((String)this.getTo())) : Uint256.DEFAULT)));
        result.add(Pair.of((Object)"gasLimit", (Object)new Uint256(this.getGasLimit())));
        result.add(Pair.of((Object)"gasPerPubdataByteLimit", (Object)new Uint256(this.getGasPerPubdata())));
        result.add(Pair.of((Object)"maxFeePerGas", (Object)new Uint256(this.getMaxFeePerGas())));
        result.add(Pair.of((Object)"maxPriorityFeePerGas", (Object)new Uint256(this.getMaxPriorityFeePerGas())));
        result.add(Pair.of((Object)"paymaster", (Object)(this.getPaymaster() != null ? new Uint256(Numeric.toBigInt((String)this.getPaymaster())) : Uint256.DEFAULT)));
        result.add(Pair.of((Object)"nonce", (Object)new Uint256(this.getNonce())));
        result.add(Pair.of((Object)"value", (Object)(this.getValue() != null ? new Uint256(this.getValue()) : Uint256.DEFAULT)));
        result.add(Pair.of((Object)"data", (Object)(this.getData() != null ? new DynamicBytes(Numeric.hexStringToByteArray((String)this.getData())) : DynamicBytes.DEFAULT)));
        result.add(Pair.of((Object)"factoryDeps", this.getFactoryDepsHashes()));
        result.add(Pair.of((Object)"paymasterInput", (Object)(this.getPaymasterInput() != null ? new DynamicBytes(this.getPaymasterInput()) : DynamicBytes.DEFAULT)));
        return result;
    }

    private DynamicArray<Bytes32> getFactoryDepsHashes() {
        if (this.getFactoryDeps() != null) {
            return new DynamicArray(Bytes32.class, Arrays.stream(this.getFactoryDeps()).map(ContractDeployer::hashBytecode).map(Bytes32::new).collect(Collectors.toList()));
        }
        return new DynamicArray(Bytes32.class, Collections.emptyList());
    }
}

