/*
 * Decompiled with CFR 0.152.
 */
package io.zksync.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.web3j.abi.EventValues;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.DynamicBytes;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.generated.Bytes32;
import org.web3j.crypto.Hash;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tx.Contract;
import org.web3j.utils.Assertions;
import org.web3j.utils.Numeric;

public class ContractDeployer {
    private static final BigInteger MAX_BYTECODE_SIZE = BigInteger.valueOf(2L).pow(16);
    public static final String CREATE_PREFIX = Hash.sha3String((String)"zksyncCreate");
    public static final String CREATE2_PREFIX = Hash.sha3String((String)"zksyncCreate2");

    public static Address computeL2Create2Address(Address sender, byte[] bytecode, byte[] constructor, byte[] salt) {
        Address address;
        Assertions.verifyPrecondition((salt.length == 32 ? 1 : 0) != 0, (String)"Salt length must be 32 bytes");
        byte[] senderBytes = Numeric.toBytesPadded((BigInteger)sender.toUint().getValue(), (int)32);
        byte[] bytecodeHash = ContractDeployer.hashBytecode(bytecode);
        byte[] constructorHash = Hash.sha3((byte[])constructor);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            output.write(Numeric.hexStringToByteArray((String)CREATE2_PREFIX));
            output.write(senderBytes);
            output.write(salt);
            output.write(bytecodeHash);
            output.write(constructorHash);
            byte[] result = Hash.sha3((byte[])output.toByteArray());
            address = new Address(Numeric.toBigInt((byte[])ArrayUtils.subarray((byte[])result, (int)12, (int)result.length)));
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        output.close();
        return address;
    }

    public static Address computeL2CreateAddress(Address sender, BigInteger nonce) {
        Address address;
        byte[] senderBytes = Numeric.toBytesPadded((BigInteger)sender.toUint().getValue(), (int)32);
        byte[] nonceBytes = Numeric.toBytesPadded((BigInteger)nonce, (int)32);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            output.write(Numeric.hexStringToByteArray((String)CREATE_PREFIX));
            output.write(senderBytes);
            output.write(nonceBytes);
            byte[] result = Hash.sha3((byte[])output.toByteArray());
            address = new Address(Numeric.toBigInt((byte[])ArrayUtils.subarray((byte[])result, (int)12, (int)result.length)));
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        output.close();
        return address;
    }

    public static Address extractContractAddress(TransactionReceipt receipt) {
        Event contractDeployed = new Event("ContractDeployed", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Bytes32>(true){}, new TypeReference<Address>(true){}));
        EventValues deployedEvent = receipt.getLogs().stream().map(log -> Contract.staticExtractEventParameters((Event)contractDeployed, (Log)log)).filter(Objects::nonNull).reduce((ignore, last) -> last).orElseThrow(() -> new IllegalArgumentException("Receipt does not have any `ContractDeployed` event"));
        return (Address)deployedEvent.getIndexedValues().get(2);
    }

    public static byte[] hashBytecode(byte[] bytecode) {
        byte[] bytecodeHash = Hash.sha256((byte[])bytecode);
        if (bytecode.length % 32 != 0) {
            throw new IllegalArgumentException("The bytecode length in bytes must be divisible by 32");
        }
        BigInteger length = BigInteger.valueOf(bytecode.length / 32);
        if (length.compareTo(MAX_BYTECODE_SIZE) > 0) {
            throw new IllegalArgumentException("Bytecode length must be less than 2^16 bytes");
        }
        byte[] codeHashVersion = new byte[]{1, 0};
        byte[] bytecodeLength = Numeric.toBytesPadded((BigInteger)length, (int)2);
        System.arraycopy(codeHashVersion, 0, bytecodeHash, 0, codeHashVersion.length);
        System.arraycopy(bytecodeLength, 0, bytecodeHash, 2, bytecodeLength.length);
        return bytecodeHash;
    }

    public static Function encodeCreate2(byte[] bytecode) {
        return ContractDeployer.encodeCreate2(bytecode, new byte[0], new byte[32]);
    }

    public static Function encodeCreate2(byte[] bytecode, byte[] calldata) {
        return ContractDeployer.encodeCreate2(bytecode, calldata, new byte[32]);
    }

    public static Function encodeCreate2(byte[] bytecode, byte[] calldata, byte[] salt) {
        Assertions.verifyPrecondition((salt.length == 32 ? 1 : 0) != 0, (String)"Salt length must be 32 bytes");
        byte[] bytecodeHash = ContractDeployer.hashBytecode(bytecode);
        return new Function("create2", Arrays.asList(new Bytes32(salt), new Bytes32(bytecodeHash), new DynamicBytes(calldata)), Collections.emptyList());
    }

    public static Function encodeCreate(byte[] bytecode) {
        return ContractDeployer.encodeCreate(bytecode, new byte[0]);
    }

    public static Function encodeCreate(byte[] bytecode, byte[] calldata) {
        byte[] bytecodeHash = ContractDeployer.hashBytecode(bytecode);
        return new Function("create", Arrays.asList(new Bytes32(new byte[32]), new Bytes32(bytecodeHash), new DynamicBytes(calldata)), Collections.emptyList());
    }

    public static Function encodeCreate2Account(byte[] bytecode) {
        return ContractDeployer.encodeCreate2Account(bytecode, new byte[0], new byte[32]);
    }

    public static Function encodeCreate2Account(byte[] bytecode, byte[] calldata) {
        return ContractDeployer.encodeCreate2Account(bytecode, calldata, new byte[32]);
    }

    public static Function encodeCreate2Account(byte[] bytecode, byte[] calldata, byte[] salt) {
        Assertions.verifyPrecondition((salt.length == 32 ? 1 : 0) != 0, (String)"Salt length must be 32 bytes");
        byte[] bytecodeHash = ContractDeployer.hashBytecode(bytecode);
        return new Function("create2Account", Arrays.asList(new Bytes32(salt), new Bytes32(bytecodeHash), new DynamicBytes(calldata)), Collections.emptyList());
    }

    public static Function encodeCreateAccount(byte[] bytecode) {
        return ContractDeployer.encodeCreateAccount(bytecode, new byte[0]);
    }

    public static Function encodeCreateAccount(byte[] bytecode, byte[] calldata) {
        byte[] bytecodeHash = ContractDeployer.hashBytecode(bytecode);
        return new Function("createAccount", Arrays.asList(new Bytes32(new byte[32]), new Bytes32(bytecodeHash), new DynamicBytes(calldata)), Collections.emptyList());
    }
}

