/*
 * Decompiled with CFR 0.152.
 */
package io.zksync.utils;

import io.zksync.protocol.core.L2ToL1MessageProof;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.web3j.abi.datatypes.Address;
import org.web3j.crypto.Hash;
import org.web3j.utils.Numeric;

public class Messenger {
    public static byte[] getHashedMessage(Address sender, byte[] message, BigInteger txNumberInBlock) {
        byte[] byArray;
        byte[] messageHash = Hash.sha3((byte[])message);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            output.write(0);
            output.write(1);
            output.write(Numeric.toBytesPadded((BigInteger)txNumberInBlock, (int)2));
            output.write(Numeric.hexStringToByteArray((String)"0x0000000000000000000000000000000000008008"));
            output.write(Numeric.toBytesPadded((BigInteger)sender.toUint().getValue(), (int)32));
            output.write(messageHash);
            byArray = Hash.sha3((byte[])output.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        output.close();
        return byArray;
    }

    public static boolean verifyMessage(L2ToL1MessageProof proof, byte[] messageHash) {
        int id = proof.getId();
        byte[] result = messageHash;
        for (String e : proof.getProof()) {
            byte[] bytes = (id & 1) == 0 ? ArrayUtils.addAll((byte[])result, (byte[])Numeric.hexStringToByteArray((String)e)) : ArrayUtils.addAll((byte[])Numeric.hexStringToByteArray((String)e), (byte[])result);
            result = Hash.sha3((byte[])bytes);
            id /= 2;
        }
        return Arrays.equals(result, Numeric.hexStringToByteArray((String)proof.getRoot()));
    }
}

