/*
 * Decompiled with CFR 0.152.
 */
package io.zksync.wrappers;

import io.reactivex.Flowable;
import io.reactivex.functions.Function;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.Utils;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Bool;
import org.web3j.abi.datatypes.DynamicArray;
import org.web3j.abi.datatypes.DynamicBytes;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.generated.Bytes32;
import org.web3j.abi.datatypes.generated.Uint16;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.RemoteFunctionCall;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.BaseEventResponse;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tx.Contract;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;

public class IL1Bridge
extends Contract {
    public static final String BINARY = "0x";
    public static final String FUNC_CLAIMFAILEDDEPOSIT = "claimFailedDeposit";
    public static final String FUNC_DEPOSIT = "deposit";
    public static final String FUNC_FINALIZEWITHDRAWAL = "finalizeWithdrawal";
    public static final String FUNC_ISWITHDRAWALFINALIZED = "isWithdrawalFinalized";
    public static final String FUNC_L2TOKENADDRESS = "l2TokenAddress";
    public static final Event CLAIMEDFAILEDDEPOSIT_EVENT = new Event("ClaimedFailedDeposit", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Uint256>(){}));
    public static final Event DEPOSITINITIATED_EVENT = new Event("DepositInitiated", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Uint256>(){}));
    public static final Event WITHDRAWALFINALIZED_EVENT = new Event("WithdrawalFinalized", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Uint256>(){}));
    protected static final HashMap<String, String> _addresses = new HashMap();

    @Deprecated
    protected IL1Bridge(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    protected IL1Bridge(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, credentials, contractGasProvider);
    }

    @Deprecated
    protected IL1Bridge(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    protected IL1Bridge(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static List<ClaimedFailedDepositEventResponse> getClaimedFailedDepositEvents(TransactionReceipt transactionReceipt) {
        List valueList = IL1Bridge.staticExtractEventParametersWithLog((Event)CLAIMEDFAILEDDEPOSIT_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<ClaimedFailedDepositEventResponse> responses = new ArrayList<ClaimedFailedDepositEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ClaimedFailedDepositEventResponse typedResponse = new ClaimedFailedDepositEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.to = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse.l1Token = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
            typedResponse.amount = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<ClaimedFailedDepositEventResponse> claimedFailedDepositEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, ClaimedFailedDepositEventResponse>(){

            public ClaimedFailedDepositEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = IL1Bridge.this.extractEventParametersWithLog(CLAIMEDFAILEDDEPOSIT_EVENT, log);
                ClaimedFailedDepositEventResponse typedResponse = new ClaimedFailedDepositEventResponse();
                typedResponse.log = log;
                typedResponse.to = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
                typedResponse.l1Token = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
                typedResponse.amount = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<ClaimedFailedDepositEventResponse> claimedFailedDepositEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)CLAIMEDFAILEDDEPOSIT_EVENT));
        return this.claimedFailedDepositEventFlowable(filter);
    }

    public static List<DepositInitiatedEventResponse> getDepositInitiatedEvents(TransactionReceipt transactionReceipt) {
        List valueList = IL1Bridge.staticExtractEventParametersWithLog((Event)DEPOSITINITIATED_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<DepositInitiatedEventResponse> responses = new ArrayList<DepositInitiatedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            DepositInitiatedEventResponse typedResponse = new DepositInitiatedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.from = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse.to = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
            typedResponse.l1Token = (String)((Type)eventValues.getIndexedValues().get(2)).getValue();
            typedResponse.amount = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<DepositInitiatedEventResponse> depositInitiatedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, DepositInitiatedEventResponse>(){

            public DepositInitiatedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = IL1Bridge.this.extractEventParametersWithLog(DEPOSITINITIATED_EVENT, log);
                DepositInitiatedEventResponse typedResponse = new DepositInitiatedEventResponse();
                typedResponse.log = log;
                typedResponse.from = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
                typedResponse.to = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
                typedResponse.l1Token = (String)((Type)eventValues.getIndexedValues().get(2)).getValue();
                typedResponse.amount = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<DepositInitiatedEventResponse> depositInitiatedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)DEPOSITINITIATED_EVENT));
        return this.depositInitiatedEventFlowable(filter);
    }

    public static List<WithdrawalFinalizedEventResponse> getWithdrawalFinalizedEvents(TransactionReceipt transactionReceipt) {
        List valueList = IL1Bridge.staticExtractEventParametersWithLog((Event)WITHDRAWALFINALIZED_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<WithdrawalFinalizedEventResponse> responses = new ArrayList<WithdrawalFinalizedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            WithdrawalFinalizedEventResponse typedResponse = new WithdrawalFinalizedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.to = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse.l1Token = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
            typedResponse.amount = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<WithdrawalFinalizedEventResponse> withdrawalFinalizedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, WithdrawalFinalizedEventResponse>(){

            public WithdrawalFinalizedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = IL1Bridge.this.extractEventParametersWithLog(WITHDRAWALFINALIZED_EVENT, log);
                WithdrawalFinalizedEventResponse typedResponse = new WithdrawalFinalizedEventResponse();
                typedResponse.log = log;
                typedResponse.to = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
                typedResponse.l1Token = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
                typedResponse.amount = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<WithdrawalFinalizedEventResponse> withdrawalFinalizedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)WITHDRAWALFINALIZED_EVENT));
        return this.withdrawalFinalizedEventFlowable(filter);
    }

    public RemoteFunctionCall<TransactionReceipt> claimFailedDeposit(String _depositSender, String _l1Token, byte[] _l2TxHash, BigInteger _l2BlockNumber, BigInteger _l2MessageIndex, BigInteger _l2TxNumberInBlock, List<byte[]> _merkleProof) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_CLAIMFAILEDDEPOSIT, Arrays.asList(new Address(_depositSender), new Address(_l1Token), new Bytes32(_l2TxHash), new Uint256(_l2BlockNumber), new Uint256(_l2MessageIndex), new Uint16(_l2TxNumberInBlock), new DynamicArray(Bytes32.class, Utils.typeMap(_merkleProof, Bytes32.class))), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> deposit(String _l2Receiver, String _l1Token, BigInteger _amount, BigInteger _l2TxGasLimit, BigInteger _l2TxGasPerPubdataByte, BigInteger weiValue) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_DEPOSIT, Arrays.asList(new Address(_l2Receiver), new Address(_l1Token), new Uint256(_amount), new Uint256(_l2TxGasLimit), new Uint256(_l2TxGasPerPubdataByte)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function, weiValue);
    }

    public RemoteFunctionCall<TransactionReceipt> finalizeWithdrawal(BigInteger _l2BlockNumber, BigInteger _l2MessageIndex, BigInteger _l2TxNumberInBlock, byte[] _message, List<byte[]> _merkleProof) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_FINALIZEWITHDRAWAL, Arrays.asList(new Uint256(_l2BlockNumber), new Uint256(_l2MessageIndex), new Uint16(_l2TxNumberInBlock), new DynamicBytes(_message), new DynamicArray(Bytes32.class, Utils.typeMap(_merkleProof, Bytes32.class))), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<Boolean> isWithdrawalFinalized(BigInteger _l2BlockNumber, BigInteger _l2MessageIndex) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ISWITHDRAWALFINALIZED, Arrays.asList(new Uint256(_l2BlockNumber), new Uint256(_l2MessageIndex)), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<String> l2TokenAddress(String _l1Token) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_L2TOKENADDRESS, Arrays.asList(new Address(_l1Token)), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    @Deprecated
    public static IL1Bridge load(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return new IL1Bridge(contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    @Deprecated
    public static IL1Bridge load(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return new IL1Bridge(contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    public static IL1Bridge load(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return new IL1Bridge(contractAddress, web3j, credentials, contractGasProvider);
    }

    public static IL1Bridge load(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return new IL1Bridge(contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static RemoteCall<IL1Bridge> deploy(Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return IL1Bridge.deployRemoteCall(IL1Bridge.class, (Web3j)web3j, (Credentials)credentials, (ContractGasProvider)contractGasProvider, (String)BINARY, (String)"");
    }

    @Deprecated
    public static RemoteCall<IL1Bridge> deploy(Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return IL1Bridge.deployRemoteCall(IL1Bridge.class, (Web3j)web3j, (Credentials)credentials, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)BINARY, (String)"");
    }

    public static RemoteCall<IL1Bridge> deploy(Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return IL1Bridge.deployRemoteCall(IL1Bridge.class, (Web3j)web3j, (TransactionManager)transactionManager, (ContractGasProvider)contractGasProvider, (String)BINARY, (String)"");
    }

    @Deprecated
    public static RemoteCall<IL1Bridge> deploy(Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return IL1Bridge.deployRemoteCall(IL1Bridge.class, (Web3j)web3j, (TransactionManager)transactionManager, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)BINARY, (String)"");
    }

    protected String getStaticDeployedAddress(String networkId) {
        return _addresses.get(networkId);
    }

    public static String getPreviouslyDeployedAddress(String networkId) {
        return _addresses.get(networkId);
    }

    public static class WithdrawalFinalizedEventResponse
    extends BaseEventResponse {
        public String to;
        public String l1Token;
        public BigInteger amount;
    }

    public static class DepositInitiatedEventResponse
    extends BaseEventResponse {
        public String from;
        public String to;
        public String l1Token;
        public BigInteger amount;
    }

    public static class ClaimedFailedDepositEventResponse
    extends BaseEventResponse {
        public String to;
        public String l1Token;
        public BigInteger amount;
    }
}

