/*
 * Decompiled with CFR 0.152.
 */
package io.zksync.wrappers;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.RemoteFunctionCall;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tx.Contract;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;

public class NonceHolder
extends Contract {
    public static final String BINARY = "Bin file was not provided";
    public static final String FUNC_GETACCOUNTNONCE = "getAccountNonce";
    public static final String FUNC_GETDEPLOYMENTNONCE = "getDeploymentNonce";
    public static final String FUNC_GETRAWNONCE = "getRawNonce";
    public static final String FUNC_INCREMENTDEPLOYMENTNONCE = "incrementDeploymentNonce";
    public static final String FUNC_INCREMENTNONCE = "incrementNonce";
    public static final String FUNC_INCREMENTNONCEIFEQUALS = "incrementNonceIfEquals";

    @Deprecated
    protected NonceHolder(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    protected NonceHolder(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, credentials, contractGasProvider);
    }

    @Deprecated
    protected NonceHolder(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    protected NonceHolder(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public RemoteFunctionCall<BigInteger> getAccountNonce() {
        Function function = new Function(FUNC_GETACCOUNTNONCE, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> getDeploymentNonce(String _address) {
        Function function = new Function(FUNC_GETDEPLOYMENTNONCE, Arrays.asList(new Address(160, _address)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> getRawNonce(String _address) {
        Function function = new Function(FUNC_GETRAWNONCE, Arrays.asList(new Address(160, _address)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<TransactionReceipt> incrementDeploymentNonce(String _address) {
        Function function = new Function(FUNC_INCREMENTDEPLOYMENTNONCE, Arrays.asList(new Address(160, _address)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> incrementNonce() {
        Function function = new Function(FUNC_INCREMENTNONCE, Arrays.asList(new Type[0]), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> incrementNonceIfEquals(BigInteger _expectedNonce) {
        Function function = new Function(FUNC_INCREMENTNONCEIFEQUALS, Arrays.asList(new Uint256(_expectedNonce)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    @Deprecated
    public static NonceHolder load(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return new NonceHolder(contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    @Deprecated
    public static NonceHolder load(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return new NonceHolder(contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    public static NonceHolder load(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return new NonceHolder(contractAddress, web3j, credentials, contractGasProvider);
    }

    public static NonceHolder load(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return new NonceHolder(contractAddress, web3j, transactionManager, contractGasProvider);
    }
}

