/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.flyway;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.opentable.db.postgres.embedded.DatabasePreparer;
import com.opentable.db.postgres.embedded.PreparedDbProvider;
import io.zonky.test.db.flyway.BlockingDataSourceWrapper;
import io.zonky.test.db.flyway.FlywayConfigSnapshot;
import io.zonky.test.db.flyway.FlywayDataSourceContext;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import javax.sql.DataSource;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.flywaydb.core.Flyway;
import org.postgresql.ds.PGSimpleDataSource;
import org.springframework.core.task.TaskExecutor;
import org.springframework.util.concurrent.CompletableToListenableFutureAdapter;
import org.springframework.util.concurrent.ListenableFuture;

public class DefaultFlywayDataSourceContext
implements FlywayDataSourceContext {
    protected static final int DEFAULT_MAX_RETRY_ATTEMPTS = 3;
    protected static final LoadingCache<Integer, Semaphore> CONNECTION_SEMAPHORES = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Integer, Semaphore>(){

        public Semaphore load(Integer key) {
            return new Semaphore(100);
        }
    });
    protected static final ThreadLocal<DataSource> preparerDataSourceHolder = new ThreadLocal();
    protected volatile CompletableFuture<DataSource> dataSourceFuture = CompletableFuture.completedFuture(null);
    protected int maxAttempts = 3;
    protected TaskExecutor bootstrapExecutor;

    public Class<?> getTargetClass() {
        return DataSource.class;
    }

    public boolean isStatic() {
        return false;
    }

    public Object getTarget() throws Exception {
        DataSource threadBoundDataSource = preparerDataSourceHolder.get();
        if (threadBoundDataSource != null) {
            return threadBoundDataSource;
        }
        if (this.bootstrapExecutor == null && !this.dataSourceFuture.isDone()) {
            throw new IllegalStateException("dataSource is not initialized yet");
        }
        DataSource dataSource = this.dataSourceFuture.get();
        Preconditions.checkState((dataSource != null ? 1 : 0) != 0, (Object)"Error when initializing the data source");
        return dataSource;
    }

    public void releaseTarget(Object target) throws Exception {
    }

    @Override
    public synchronized ListenableFuture<Void> reload(Flyway flyway) {
        Executor executor = this.bootstrapExecutor != null ? this.bootstrapExecutor : Runnable::run;
        CompletionStage reloadFuture = this.dataSourceFuture.thenApplyAsync(x -> {
            for (int current = 1; current <= this.maxAttempts; ++current) {
                try {
                    FlywayDatabasePreparer preparer = new FlywayDatabasePreparer(flyway);
                    PreparedDbProvider provider = PreparedDbProvider.forPreparer((DatabasePreparer)preparer);
                    PGSimpleDataSource dataSource = (PGSimpleDataSource)provider.createDataSource();
                    Semaphore semaphore = (Semaphore)CONNECTION_SEMAPHORES.get((Object)dataSource.getPortNumber());
                    return new BlockingDataSourceWrapper((DataSource)dataSource, semaphore);
                }
                catch (Exception e) {
                    if (ExceptionUtils.indexOfType((Throwable)e, IOException.class) != -1 && current != this.maxAttempts) continue;
                    throw new CompletionException(e);
                }
            }
            throw new IllegalStateException("maxAttempts parameter must be greater or equal to 1");
        }, executor);
        this.dataSourceFuture = ((CompletableFuture)reloadFuture).exceptionally(throwable -> null);
        return new CompletableToListenableFutureAdapter((CompletableFuture)((CompletableFuture)reloadFuture).thenApply(dataSource -> null));
    }

    public void setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public void setBootstrapExecutor(TaskExecutor bootstrapExecutor) {
        this.bootstrapExecutor = bootstrapExecutor;
    }

    protected FlywayConfigSnapshot createConfigSnapshot(Flyway flyway) {
        return new FlywayConfigSnapshot(flyway);
    }

    protected class FlywayDatabasePreparer
    implements DatabasePreparer {
        private final FlywayConfigSnapshot configSnapshot;
        private final Flyway flyway;

        public FlywayDatabasePreparer(Flyway flyway) {
            this.configSnapshot = DefaultFlywayDataSourceContext.this.createConfigSnapshot(flyway);
            this.flyway = flyway;
        }

        public void prepare(DataSource ds) throws SQLException {
            preparerDataSourceHolder.set(ds);
            try {
                this.flyway.migrate();
            }
            finally {
                preparerDataSourceHolder.remove();
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FlywayDatabasePreparer that = (FlywayDatabasePreparer)o;
            return Objects.equals(this.configSnapshot, that.configSnapshot);
        }

        public int hashCode() {
            return Objects.hash(this.configSnapshot);
        }
    }
}

