/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.flyway;

import io.zonky.test.db.flyway.FlywayConfigSnapshot;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.flywaydb.core.Flyway;
import org.flywaydb.test.annotation.FlywayTest;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.ClassUtils;

public class FlywayClassUtils {
    private static final boolean flywayNameAttributePresent;
    private static final boolean flywayBaselineAttributePresent;
    private static final boolean repeatableAnnotationPresent;
    private static final int flywayVersion;

    private FlywayClassUtils() {
    }

    public static boolean isFlywayNameAttributePresent() {
        return flywayNameAttributePresent;
    }

    public static boolean isFlywayBaselineAttributePresent() {
        return flywayBaselineAttributePresent;
    }

    public static boolean isRepeatableFlywayTestAnnotationPresent() {
        return repeatableAnnotationPresent;
    }

    public static int getFlywayVersion() {
        return flywayVersion;
    }

    static {
        String version;
        flywayNameAttributePresent = ClassUtils.hasMethod(FlywayTest.class, (String)"flywayName", (Class[])new Class[0]);
        flywayBaselineAttributePresent = ClassUtils.hasMethod(FlywayTest.class, (String)"invokeBaselineDB", (Class[])new Class[0]);
        repeatableAnnotationPresent = ClassUtils.isPresent((String)"org.flywaydb.test.annotation.FlywayTests", (ClassLoader)FlywayClassUtils.class.getClassLoader());
        try {
            ClassPathResource versionResource = new ClassPathResource("org/flywaydb/core/internal/version.txt", FlywayConfigSnapshot.class.getClassLoader());
            version = versionResource.exists() ? ((String)IOUtils.readLines((InputStream)versionResource.getInputStream()).get(0)).replaceAll("^(\\d+)\\.(\\d+).*", "$1$2") : (ClassUtils.hasMethod(Flyway.class, (String)"isPlaceholderReplacement", (Class[])new Class[0]) ? "32" : (ClassUtils.hasMethod(Flyway.class, (String)"getBaselineVersion", (Class[])new Class[0]) ? "31" : "30"));
        }
        catch (Exception e) {
            LoggerFactory.getLogger(FlywayConfigSnapshot.class).error("Error resolving flyway version", (Throwable)e);
            version = "0";
        }
        flywayVersion = Integer.valueOf(version);
    }
}

