/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.flyway;

import com.google.common.collect.Iterables;
import com.google.common.collect.ObjectArrays;
import io.zonky.test.db.flyway.FlywayClassUtils;
import io.zonky.test.db.flyway.FlywayDataSourceContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.flywaydb.core.api.resolver.ResolvedMigration;
import org.flywaydb.core.internal.util.scanner.Scanner;
import org.flywaydb.test.annotation.FlywayTest;
import org.flywaydb.test.annotation.FlywayTests;
import org.flywaydb.test.junit.FlywayTestExecutionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.test.context.TestContext;
import org.springframework.test.util.ReflectionTestUtils;
import org.springframework.util.CollectionUtils;

public class OptimizedFlywayTestExecutionListener
extends FlywayTestExecutionListener
implements Ordered {
    private static final Logger logger = LoggerFactory.getLogger(OptimizedFlywayTestExecutionListener.class);
    private static final boolean flywayNameAttributePresent = FlywayClassUtils.isFlywayNameAttributePresent();
    private static final boolean flywayBaselineAttributePresent = FlywayClassUtils.isFlywayBaselineAttributePresent();
    private static final boolean repeatableAnnotationPresent = FlywayClassUtils.isRepeatableFlywayTestAnnotationPresent();
    private static final int flywayVersion = FlywayClassUtils.getFlywayVersion();
    private int order = 3900;

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void beforeTestClass(TestContext testContext) throws Exception {
        Class testClass = testContext.getTestClass();
        FlywayTest[] annotations = this.findFlywayTestAnnotations(testClass);
        if (annotations.length > 1) {
            logger.warn("Optimized database loading is not supported when using multiple flyway test annotations");
        }
        for (FlywayTest annotation : annotations) {
            this.optimizedDbReset(testContext, annotation);
        }
    }

    public void beforeTestMethod(TestContext testContext) throws Exception {
        Method testMethod = testContext.getTestMethod();
        FlywayTest[] annotations = this.findFlywayTestAnnotations(testMethod);
        if (annotations.length > 1) {
            logger.warn("Optimized database loading is not supported when using multiple flyway test annotations");
        }
        for (FlywayTest annotation : annotations) {
            this.optimizedDbReset(testContext, annotation);
        }
    }

    protected FlywayTest[] findFlywayTestAnnotations(AnnotatedElement element) {
        FlywayTests containerAnnotation;
        if (repeatableAnnotationPresent && (containerAnnotation = OptimizedFlywayTestExecutionListener.findAnnotation(element, FlywayTests.class)) != null) {
            return containerAnnotation.value();
        }
        FlywayTest annotation = OptimizedFlywayTestExecutionListener.findAnnotation(element, FlywayTest.class);
        if (annotation != null) {
            return new FlywayTest[]{annotation};
        }
        return new FlywayTest[0];
    }

    protected synchronized void optimizedDbReset(TestContext testContext, FlywayTest annotation) throws Exception {
        FlywayDataSourceContext dataSourceContext;
        ApplicationContext applicationContext;
        Flyway flywayBean;
        String dbResetMethodName;
        String string = dbResetMethodName = repeatableAnnotationPresent ? "dbResetWithAnnotation" : "dbResetWithAnotation";
        if (annotation != null && annotation.invokeCleanDB() && annotation.invokeMigrateDB() && (!flywayBaselineAttributePresent || !annotation.invokeBaselineDB()) && (flywayBean = this.getFlywayBean(applicationContext = testContext.getApplicationContext(), annotation)) != null && (dataSourceContext = OptimizedFlywayTestExecutionListener.getDataSourceContext(applicationContext, flywayBean)) != null) {
            dataSourceContext.getTarget();
            OptimizedFlywayTestExecutionListener.prepareDataSourceContext(dataSourceContext, flywayBean, annotation);
            FlywayTest adjustedAnnotation = OptimizedFlywayTestExecutionListener.copyAnnotation(annotation, false, false, true);
            ReflectionTestUtils.invokeMethod((Object)((Object)this), (String)dbResetMethodName, (Object[])new Object[]{testContext, adjustedAnnotation});
            return;
        }
        try {
            ReflectionTestUtils.invokeMethod((Object)((Object)this), (String)dbResetMethodName, (Object[])new Object[]{testContext, annotation});
        }
        catch (FlywayException e) {
            String errorCode;
            if (e.getCause() instanceof SQLException && (errorCode = ((SQLException)e.getCause()).getSQLState()) != null && errorCode.matches("(42723|42P06|42P07|42712|42710)")) {
                logger.error("HINT: Check that you have correctly set org.flywaydb.core.Flyway#schemaNames property!!!");
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void prepareDataSourceContext(FlywayDataSourceContext dataSourceContext, Flyway flywayBean, FlywayTest annotation) throws Exception {
        if (OptimizedFlywayTestExecutionListener.isAppendable(flywayBean, annotation)) {
            dataSourceContext.reload(flywayBean).get();
        } else {
            Object[] oldLocations = flywayBean.getLocations();
            try {
                if (annotation.overrideLocations()) {
                    flywayBean.setLocations(annotation.locationsForMigrate());
                } else {
                    flywayBean.setLocations((String[])ObjectArrays.concat((Object[])oldLocations, (Object[])annotation.locationsForMigrate(), String.class));
                }
                dataSourceContext.reload(flywayBean).get();
            }
            finally {
                flywayBean.setLocations((String[])oldLocations);
            }
        }
    }

    protected static boolean isAppendable(Flyway flyway, FlywayTest annotation) {
        if (annotation.overrideLocations()) {
            return false;
        }
        if (ArrayUtils.isEmpty((Object[])annotation.locationsForMigrate())) {
            return true;
        }
        MigrationVersion testVersion = OptimizedFlywayTestExecutionListener.findFirstVersion(flyway, annotation.locationsForMigrate());
        if (testVersion == MigrationVersion.EMPTY) {
            return true;
        }
        MigrationVersion coreVersion = OptimizedFlywayTestExecutionListener.findLastVersion(flyway, flyway.getLocations());
        return coreVersion.compareTo(testVersion) < 0;
    }

    protected static MigrationVersion findFirstVersion(Flyway flyway, String ... locations) {
        MigrationResolver resolver = OptimizedFlywayTestExecutionListener.createMigrationResolver(flyway, locations);
        Collection migrations = resolver.resolveMigrations();
        if (CollectionUtils.isEmpty((Collection)migrations)) {
            return MigrationVersion.EMPTY;
        }
        return ((ResolvedMigration)Iterables.getFirst((Iterable)migrations, null)).getVersion();
    }

    protected static MigrationVersion findLastVersion(Flyway flyway, String ... locations) {
        MigrationResolver resolver = OptimizedFlywayTestExecutionListener.createMigrationResolver(flyway, locations);
        Collection migrations = resolver.resolveMigrations();
        if (CollectionUtils.isEmpty((Collection)migrations)) {
            return MigrationVersion.EMPTY;
        }
        return ((ResolvedMigration)Iterables.getLast((Iterable)migrations)).getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static MigrationResolver createMigrationResolver(Flyway flyway, String ... locations) {
        String[] oldLocations = flyway.getLocations();
        try {
            flyway.setLocations(locations);
            if (flywayVersion >= 40) {
                Scanner scanner = new Scanner(flyway.getClassLoader());
                MigrationResolver migrationResolver = (MigrationResolver)ReflectionTestUtils.invokeMethod((Object)flyway, (String)"createMigrationResolver", (Object[])new Object[]{null, scanner});
                return migrationResolver;
            }
            MigrationResolver migrationResolver = (MigrationResolver)ReflectionTestUtils.invokeMethod((Object)flyway, (String)"createMigrationResolver", (Object[])new Object[]{null});
            return migrationResolver;
        }
        finally {
            flyway.setLocations(oldLocations);
        }
    }

    protected Flyway getFlywayBean(ApplicationContext applicationContext, FlywayTest annotation) {
        if (flywayNameAttributePresent) {
            return (Flyway)ReflectionTestUtils.invokeMethod((Object)((Object)this), (String)"getBean", (Object[])new Object[]{applicationContext, Flyway.class, annotation.flywayName()});
        }
        return (Flyway)ReflectionTestUtils.invokeMethod((Object)((Object)this), (String)"getBean", (Object[])new Object[]{applicationContext, Flyway.class});
    }

    protected static FlywayDataSourceContext getDataSourceContext(ApplicationContext context, Flyway flywayBean) {
        Map flywayBeans = context.getBeansOfType(Flyway.class);
        String flywayBeanName = flywayBeans.entrySet().stream().filter(e -> e.getValue() == flywayBean).map(Map.Entry::getKey).findFirst().orElse("default");
        try {
            return (FlywayDataSourceContext)context.getBean(flywayBeanName + "DataSourceContext", FlywayDataSourceContext.class);
        }
        catch (BeansException beansException) {
            try {
                return (FlywayDataSourceContext)context.getBean(FlywayDataSourceContext.class);
            }
            catch (BeansException beansException2) {
                return null;
            }
        }
    }

    protected static <A extends Annotation> A findAnnotation(AnnotatedElement annotatedElement, Class<A> annotationType) {
        if (annotatedElement instanceof Class) {
            return (A)AnnotationUtils.findAnnotation((Class)((Class)annotatedElement), annotationType);
        }
        if (annotatedElement instanceof Method) {
            return (A)AnnotationUtils.findAnnotation((Method)((Method)annotatedElement), annotationType);
        }
        return (A)AnnotationUtils.findAnnotation((AnnotatedElement)annotatedElement, annotationType);
    }

    private static FlywayTest copyAnnotation(FlywayTest annotation, boolean invokeCleanDB, boolean invokeBaselineDB, boolean invokeMigrateDB) {
        Map attributes = AnnotationUtils.getAnnotationAttributes((Annotation)annotation);
        attributes.put("invokeCleanDB", invokeCleanDB);
        attributes.put("invokeBaselineDB", invokeBaselineDB);
        attributes.put("invokeMigrateDB", invokeMigrateDB);
        return (FlywayTest)AnnotationUtils.synthesizeAnnotation((Map)attributes, FlywayTest.class, null);
    }
}

