/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.postgres;

import io.zonky.test.db.flyway.FlywayDataSourceContext;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.flywaydb.core.Flyway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.util.concurrent.ListenableFuture;

public class FlywayEmbeddedPostgresDataSourceFactoryBean
implements FactoryBean<DataSource>,
BeanPostProcessor,
InitializingBean,
Ordered {
    private static final Logger logger = LoggerFactory.getLogger(FlywayEmbeddedPostgresDataSourceFactoryBean.class);
    private final String flywayName;
    private final FlywayDataSourceContext dataSourceContext;
    private DataSource proxyInstance;

    public FlywayEmbeddedPostgresDataSourceFactoryBean(String flywayName, FlywayDataSourceContext dataSourceContext) {
        this.flywayName = flywayName;
        this.dataSourceContext = dataSourceContext;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public boolean isSingleton() {
        return true;
    }

    public Class<?> getObjectType() {
        return DataSource.class;
    }

    public DataSource getObject() throws Exception {
        return this.proxyInstance;
    }

    public void afterPropertiesSet() throws Exception {
        this.proxyInstance = (DataSource)ProxyFactory.getProxy(DataSource.class, (TargetSource)this.dataSourceContext);
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof Flyway && StringUtils.equals((CharSequence)beanName, (CharSequence)this.flywayName)) {
            ListenableFuture<Void> reloadFuture = this.dataSourceContext.reload((Flyway)bean);
            reloadFuture.addCallback(r -> {}, e -> logger.error("Unexpected error during the initialization of embedded database", e));
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

