/*
 * Decompiled with CFR 0.152.
 */
package ir.msob.jima.cache.ral.redis.beans;

import com.fasterxml.jackson.databind.ObjectMapper;
import ir.msob.jima.cache.commons.BaseCacheService;
import java.time.Duration;
import java.util.Optional;
import org.apache.logging.log4j.util.Strings;
import org.springframework.data.redis.core.ReactiveStringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class CacheService
implements BaseCacheService {
    private final ReactiveStringRedisTemplate redisTemplate;
    private final ObjectMapper objectMapper;

    public <T> Optional<T> get(String key, Class<T> clazz) {
        String value = (String)this.redisTemplate.opsForValue().get((Object)key).toFuture().get();
        return Strings.isBlank((String)value) ? Optional.empty() : Optional.of(this.objectMapper.reader().readValue(value, clazz));
    }

    public <T> Optional<T> getAndRemove(String key, Class<T> clazz) {
        String value = (String)this.redisTemplate.opsForValue().getAndDelete((Object)key).toFuture().get();
        return Strings.isBlank((String)value) ? Optional.empty() : Optional.of(this.objectMapper.reader().readValue(value, clazz));
    }

    public <T> T put(String key, T value) {
        this.redisTemplate.opsForValue().set((Object)key, (Object)this.objectMapper.writeValueAsString(value)).toFuture().get();
        return value;
    }

    public <T> T put(String key, T value, Duration duration) {
        this.redisTemplate.opsForValue().set((Object)key, (Object)this.objectMapper.writeValueAsString(value), duration).toFuture().get();
        return value;
    }

    public boolean remove(String key) {
        return false;
    }

    public CacheService(ReactiveStringRedisTemplate redisTemplate, ObjectMapper objectMapper) {
        this.redisTemplate = redisTemplate;
        this.objectMapper = objectMapper;
    }
}

