/*
 * Decompiled with CFR 0.152.
 */
package is.codion.common.rmi.server;

import is.codion.common.NullOrEmpty;
import is.codion.common.event.Event;
import is.codion.common.rmi.client.ConnectionRequest;
import is.codion.common.rmi.server.Authenticator;
import is.codion.common.rmi.server.AuxiliaryServer;
import is.codion.common.rmi.server.AuxiliaryServerFactory;
import is.codion.common.rmi.server.DefaultServerInformation;
import is.codion.common.rmi.server.RemoteClient;
import is.codion.common.rmi.server.SerializationWhitelist;
import is.codion.common.rmi.server.Server;
import is.codion.common.rmi.server.ServerAdmin;
import is.codion.common.rmi.server.ServerConfiguration;
import is.codion.common.rmi.server.ServerInformation;
import is.codion.common.rmi.server.exception.ConnectionNotAvailableException;
import is.codion.common.rmi.server.exception.LoginException;
import is.codion.common.rmi.server.exception.ServerAuthenticationException;
import is.codion.common.scheduler.TaskScheduler;
import is.codion.common.user.User;
import java.io.ObjectInputFilter;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.UnicastRemoteObject;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServer<T extends Remote, A extends ServerAdmin>
extends UnicastRemoteObject
implements Server<T, A> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractServer.class);
    private static final String CLIENT_ID = "clientId";
    private final Map<UUID, ClientConnection<T>> connections = new ConcurrentHashMap<UUID, ClientConnection<T>>();
    private final Map<String, Authenticator> authenticators = new HashMap<String, Authenticator>();
    private final Collection<Authenticator> sharedAuthenticators = new ArrayList<Authenticator>();
    private final Collection<AuxiliaryServer> auxiliaryServers = new ArrayList<AuxiliaryServer>();
    private final TaskScheduler connectionMaintenanceScheduler;
    private final ServerConfiguration configuration;
    private final ServerInformation serverInformation;
    private final Event<?> shutdownEvent = Event.event();
    private volatile int connectionLimit = -1;
    private volatile boolean shuttingDown = false;
    private Registry registry;
    private A admin;

    protected AbstractServer(ServerConfiguration configuration) throws RemoteException {
        super(Objects.requireNonNull(configuration, "configuration").port(), configuration.rmiClientSocketFactory(), configuration.rmiServerSocketFactory());
        Runtime.getRuntime().addShutdownHook(new Thread(this::shutdown));
        try {
            this.configuration = configuration;
            this.serverInformation = new DefaultServerInformation(UUID.randomUUID(), configuration.serverName(), configuration.port(), ZonedDateTime.now());
            this.connectionMaintenanceScheduler = TaskScheduler.builder((Runnable)new MaintenanceTask()).interval(configuration.connectionMaintenanceInterval(), TimeUnit.MILLISECONDS).initialDelay(configuration.connectionMaintenanceInterval()).start();
            AbstractServer.configureSerializationWhitelist(configuration);
            this.startAuxiliaryServers(configuration.auxiliaryServerFactoryClassNames());
            this.loadAuthenticators();
        }
        catch (Throwable exception) {
            throw this.logShutdownAndReturn(new RuntimeException(exception));
        }
    }

    public final Map<RemoteClient, T> connections() {
        return this.connections.values().stream().collect(Collectors.toMap(ClientConnection::remoteClient, ClientConnection::connection));
    }

    public final T connection(UUID clientId) {
        ClientConnection<T> clientConnection = this.connections.get(Objects.requireNonNull(clientId, CLIENT_ID));
        if (clientConnection != null) {
            return (T)((Remote)clientConnection.connection());
        }
        throw new IllegalArgumentException("Client not connected: " + clientId);
    }

    public final int connectionCount() {
        return this.connections.size();
    }

    public final int getConnectionLimit() {
        return this.connectionLimit;
    }

    public final void setConnectionLimit(int connectionLimit) {
        this.connectionLimit = connectionLimit;
    }

    public final int getMaintenanceInterval() {
        return (Integer)this.connectionMaintenanceScheduler.interval().get();
    }

    public final void setMaintenanceInterval(int maintenanceInterval) {
        this.connectionMaintenanceScheduler.interval().set((Object)maintenanceInterval);
    }

    @Override
    public final ServerInformation serverInformation() {
        return this.serverInformation;
    }

    @Override
    public final boolean connectionsAvailable() {
        return !this.maximumNumberOfConnectionsReached();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final T connect(ConnectionRequest connectionRequest) throws RemoteException, ConnectionNotAvailableException, LoginException {
        if (this.shuttingDown) {
            throw new LoginException("Server is shutting down");
        }
        Objects.requireNonNull(connectionRequest, "connectionRequest");
        Objects.requireNonNull(connectionRequest.user(), "user");
        Objects.requireNonNull(connectionRequest.clientId(), CLIENT_ID);
        Objects.requireNonNull(connectionRequest.clientTypeId(), "clientTypeId");
        Map<UUID, ClientConnection<T>> map = this.connections;
        synchronized (map) {
            ClientConnection<T> clientConnection = this.connections.get(connectionRequest.clientId());
            if (clientConnection != null) {
                AbstractServer.validateUserCredentials(connectionRequest.user(), clientConnection.remoteClient().user());
                LOG.trace("Active connection exists {}", (Object)connectionRequest);
                return (T)((Remote)clientConnection.connection());
            }
            if (this.maximumNumberOfConnectionsReached()) {
                LOG.debug("Maximum number of connections reached {}", (Object)this.connectionLimit);
                throw new ConnectionNotAvailableException();
            }
            LOG.trace("No active connection found for client {}, establishing a new connection", (Object)connectionRequest);
            return (T)((Remote)this.createConnection(connectionRequest).connection());
        }
    }

    @Override
    public final void disconnect(UUID clientId) throws RemoteException {
        ClientConnection<T> clientConnection = this.connections.remove(Objects.requireNonNull(clientId, CLIENT_ID));
        if (clientConnection != null) {
            this.disconnect((Remote)clientConnection.connection());
            RemoteClient remoteClient = clientConnection.remoteClient();
            for (Authenticator authenticator : this.sharedAuthenticators) {
                authenticator.logout(remoteClient);
            }
            Authenticator authenticator = this.authenticators.get(remoteClient.clientTypeId());
            if (authenticator != null) {
                authenticator.logout(remoteClient);
            }
            LOG.debug("Client disconnected {}", (Object)remoteClient);
        }
    }

    public final void shutdown() {
        if (this.shuttingDown) {
            return;
        }
        this.shuttingDown = true;
        this.connectionMaintenanceScheduler.stop();
        AbstractServer.unexportSilently(new Remote[]{this.registry, this, this.admin});
        for (UUID clientId : new ArrayList<UUID>(this.connections.keySet())) {
            try {
                this.disconnect(clientId);
            }
            catch (RemoteException e) {
                LOG.debug("Error while disconnecting a client on shutdown: " + clientId, (Throwable)e);
            }
        }
        this.sharedAuthenticators.forEach(AbstractServer::closeAuthenticator);
        this.authenticators.values().forEach(AbstractServer::closeAuthenticator);
        this.auxiliaryServers.forEach(AbstractServer::stopAuxiliaryServer);
        ObjectInputFilter serialFilter = ObjectInputFilter.Config.getSerialFilter();
        if (serialFilter instanceof SerializationWhitelist.DryRun) {
            ((SerializationWhitelist.DryRun)serialFilter).writeToFile(this.configuration.serializationFilterWhitelist());
        }
        this.shutdownEvent.run();
    }

    public final void addAuthenticator(Authenticator authenticator) {
        Objects.requireNonNull(authenticator, "authenticator");
        if (authenticator.clientTypeId().isPresent()) {
            String clientTypeId = authenticator.clientTypeId().get();
            if (this.authenticators.containsKey(clientTypeId)) {
                throw new IllegalStateException("Authenticator for clientTypeId '" + clientTypeId + "' has alread been added");
            }
            this.authenticators.put(clientTypeId, authenticator);
        } else {
            this.sharedAuthenticators.add(authenticator);
        }
    }

    final Collection<User> users() {
        return this.connections().keySet().stream().map(ConnectionRequest::user).map(User::copy).map(User::clearPassword).collect(Collectors.toSet());
    }

    final Collection<RemoteClient> clients() {
        return this.clients((RemoteClient remoteClient) -> true);
    }

    final Collection<RemoteClient> clients(User user) {
        return this.clients((RemoteClient remoteClient) -> remoteClient.user().equals(Objects.requireNonNull(user)));
    }

    protected final void setAdmin(A admin) {
        if (this.admin != null) {
            throw new IllegalStateException("Admin has already been set for this server");
        }
        this.admin = admin;
    }

    protected final A getAdmin() {
        if (this.admin == null) {
            throw new IllegalStateException("No admin instance available");
        }
        return this.admin;
    }

    protected final void addShutdownListener(Runnable listener) {
        this.shutdownEvent.addListener(Objects.requireNonNull(listener, "listener"));
    }

    protected abstract T connect(RemoteClient var1) throws RemoteException, LoginException;

    protected abstract void disconnect(T var1) throws RemoteException;

    protected abstract void maintainConnections(Collection<ClientConnection<T>> var1) throws RemoteException;

    protected final Collection<RemoteClient> clients(String clientTypeId) {
        return this.clients((RemoteClient remoteClient) -> Objects.equals(remoteClient.clientTypeId(), Objects.requireNonNull(clientTypeId)));
    }

    protected final Registry registry() throws RemoteException {
        if (this.registry == null) {
            this.registry = LocateRegistry.createRegistry(this.configuration.registryPort());
        }
        return this.registry;
    }

    protected final <T extends Throwable> T logShutdownAndReturn(T exception) {
        LOG.error("Exception on server startup", exception);
        this.shutdown();
        return exception;
    }

    protected final Collection<AuxiliaryServer> auxiliaryServers() {
        return Collections.unmodifiableCollection(this.auxiliaryServers);
    }

    protected static void validateUserCredentials(User userToCheck, User requiredUser) throws ServerAuthenticationException {
        if (userToCheck == null || requiredUser == null || !userToCheck.username().equalsIgnoreCase(requiredUser.username()) || !Arrays.equals(userToCheck.password(), requiredUser.password())) {
            throw new ServerAuthenticationException("Wrong username or password");
        }
    }

    private boolean maximumNumberOfConnectionsReached() {
        return this.connectionLimit > -1 && this.connectionCount() >= this.connectionLimit;
    }

    private ClientConnection<T> createConnection(ConnectionRequest connectionRequest) throws LoginException, RemoteException {
        RemoteClient remoteClient = RemoteClient.remoteClient(connectionRequest, AbstractServer.clientHost((String)connectionRequest.parameters().get("clientHost")));
        for (Authenticator authenticator : this.sharedAuthenticators) {
            remoteClient = authenticator.login(remoteClient);
        }
        Authenticator clientAuthenticator = this.authenticators.get(connectionRequest.clientTypeId());
        LOG.debug("Connecting client {}, authenticator {}", (Object)connectionRequest, (Object)clientAuthenticator);
        if (clientAuthenticator != null) {
            remoteClient = clientAuthenticator.login(remoteClient);
        }
        ClientConnection<T> clientConnection = new ClientConnection<T>(remoteClient, this.connect(remoteClient));
        this.connections.put(remoteClient.clientId(), clientConnection);
        return clientConnection;
    }

    private void startAuxiliaryServers(Collection<String> auxiliaryServerFactoryClassNames) {
        try {
            for (String auxiliaryServerFactoryClassName : auxiliaryServerFactoryClassNames) {
                AuxiliaryServerFactory auxiliaryServerFactory = AuxiliaryServerFactory.instance(auxiliaryServerFactoryClassName);
                Object auxiliaryServer = auxiliaryServerFactory.createServer(this);
                this.auxiliaryServers.add((AuxiliaryServer)auxiliaryServer);
                Callable<Object> starter = () -> AbstractServer.startAuxiliaryServer(auxiliaryServer);
                Executors.newSingleThreadExecutor(new DaemonThreadFactory()).submit(starter).get();
            }
        }
        catch (InterruptedException e) {
            LOG.error("Interrupted during auxiliary server startup", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LOG.error("Starting auxiliary server", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private Collection<RemoteClient> clients(Predicate<RemoteClient> predicate) {
        return this.connections().keySet().stream().filter(predicate).map(RemoteClient::copy).map(AbstractServer::clearPasswords).collect(Collectors.toList());
    }

    private static RemoteClient clearPasswords(RemoteClient remoteClient) {
        remoteClient.user().clearPassword();
        remoteClient.databaseUser().clearPassword();
        return remoteClient;
    }

    private static void configureSerializationWhitelist(ServerConfiguration configuration) {
        String whitelistFile = configuration.serializationFilterWhitelist();
        if (NullOrEmpty.nullOrEmpty((String)whitelistFile)) {
            LOG.info("No serialization whitelist file specified");
        } else if (configuration.serializationFilterDryRun()) {
            ObjectInputFilter.Config.setSerialFilter(SerializationWhitelist.whitelistDryRun());
            LOG.info("Serialization filter dry-run enabled");
        } else {
            ObjectInputFilter.Config.setSerialFilter(SerializationWhitelist.whitelistFilter(whitelistFile));
            LOG.info("Serialization filter whitelist set: " + whitelistFile);
        }
    }

    private static void closeAuthenticator(Authenticator authenticator) {
        try {
            authenticator.close();
        }
        catch (Exception e) {
            LOG.error("Exception while closing authenticator for client type: " + authenticator.clientTypeId(), (Throwable)e);
        }
    }

    private static Object startAuxiliaryServer(AuxiliaryServer server) throws Exception {
        try {
            server.startServer();
            LOG.info("Auxiliary server started: " + server);
            return null;
        }
        catch (Exception e) {
            LOG.error("Starting auxiliary server", (Throwable)e);
            throw e;
        }
    }

    private static void stopAuxiliaryServer(AuxiliaryServer server) {
        try {
            server.stopServer();
            LOG.info("Auxiliary server stopped: " + server);
        }
        catch (Exception e) {
            LOG.error("Stopping auxiliary server", (Throwable)e);
        }
    }

    private static void unexportSilently(Remote ... remotes) {
        for (Remote remote : remotes) {
            if (remote == null) continue;
            try {
                AbstractServer.unexportObject(remote, true);
            }
            catch (NoSuchObjectException e) {
                LOG.error("Exception while unexporting " + remote + " on shutdown", (Throwable)e);
            }
        }
    }

    private static String clientHost(String requestParameterHost) {
        if (requestParameterHost == null) {
            try {
                return AbstractServer.getClientHost();
            }
            catch (ServerNotActiveException serverNotActiveException) {
                // empty catch block
            }
        }
        return requestParameterHost;
    }

    private void loadAuthenticators() {
        Authenticator.authenticators().forEach(authenticator -> {
            String clientTypeId = authenticator.clientTypeId().orElse(null);
            LOG.info("Server loading authenticator '" + authenticator.getClass().getName() + "' as service, " + (String)(clientTypeId == null ? "shared" : "(clientTypeId: '" + clientTypeId + "'"));
            this.addAuthenticator((Authenticator)authenticator);
        });
    }

    private final class MaintenanceTask
    implements Runnable {
        private MaintenanceTask() {
        }

        @Override
        public void run() {
            try {
                if (AbstractServer.this.connectionCount() > 0) {
                    AbstractServer.this.maintainConnections(Collections.unmodifiableCollection(AbstractServer.this.connections.values()));
                }
            }
            catch (Exception e) {
                LOG.error("Exception while maintaining connections", (Throwable)e);
            }
        }
    }

    protected static final class ClientConnection<T> {
        private final RemoteClient client;
        private final T connection;

        private ClientConnection(RemoteClient client, T connection) {
            this.client = client;
            this.connection = connection;
        }

        public RemoteClient remoteClient() {
            return this.client;
        }

        public T connection() {
            return this.connection;
        }
    }

    private static final class DaemonThreadFactory
    implements ThreadFactory {
        private DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            return thread;
        }
    }
}

